/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.athenz.auth.impl;

import com.yahoo.athenz.auth.Authority;
import com.yahoo.athenz.auth.Principal;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimplePrincipal
implements Principal {
    private static final Logger LOG = LoggerFactory.getLogger(SimplePrincipal.class);
    String domain;
    String name = null;
    String fullName = null;
    String creds;
    String unsignedCreds = null;
    String ip = null;
    long issueTime = 0L;
    List<String> roles = null;
    Authority authority;
    String authorizedService = null;
    String originalRequestor = null;
    String keyService = null;
    String keyId = null;
    X509Certificate x509Certificate = null;
    String applicationId = null;
    private boolean mtlsRestricted = false;
    private Principal.State state = Principal.State.ACTIVE;

    public static Principal create(String domain, String name, String creds) {
        return SimplePrincipal.create(domain, name, creds, 0L, null);
    }

    public static Principal create(String domain, String creds, List<String> roles, Authority authority) {
        if (roles == null || roles.size() == 0) {
            LOG.error("createRolePrincipal: zero roles");
            return null;
        }
        return new SimplePrincipal(domain, creds, roles, authority);
    }

    public static Principal create(String domain, String name, String creds, Authority authority) {
        return SimplePrincipal.create(domain, name, creds, 0L, authority);
    }

    public static Principal create(String domain, String name, String creds, long issueTime, Authority authority) {
        String matchDomain;
        String string = matchDomain = authority == null ? null : authority.getDomain();
        if (matchDomain != null && !domain.equals(matchDomain)) {
            LOG.error("createPrincipal: domain mismatch for user {} in authority {}", (Object)name, (Object)authority);
            return null;
        }
        return new SimplePrincipal(domain, name, creds, issueTime, authority);
    }

    public static Principal create(String appId, String creds, Authority authority) {
        if (appId == null) {
            LOG.error("createAppIdPrincipal: null appId");
            return null;
        }
        return new SimplePrincipal(null, appId, creds, 0L, authority);
    }

    private SimplePrincipal(String domain, String name, String creds, long issueTime, Authority authority) {
        this.domain = domain;
        this.name = name;
        this.creds = creds;
        this.authority = authority;
        this.issueTime = issueTime;
    }

    private SimplePrincipal(String domain, String creds, List<String> roles, Authority authority) {
        this.domain = domain;
        this.creds = creds;
        this.roles = roles;
        this.authority = authority;
    }

    public void setUnsignedCreds(String unsignedCreds) {
        this.unsignedCreds = unsignedCreds;
    }

    public void setAuthorizedService(String authorizedService) {
        this.authorizedService = authorizedService;
    }

    public void setIP(String ip) {
        this.ip = ip;
    }

    public void setOriginalRequestor(String originalRequestor) {
        this.originalRequestor = originalRequestor;
    }

    public void setKeyService(String keyService) {
        this.keyService = keyService;
    }

    public void setKeyId(String keyId) {
        this.keyId = keyId;
    }

    public void setX509Certificate(X509Certificate x509Certificate) {
        this.x509Certificate = x509Certificate;
    }

    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    public void setRoles(List<String> roles) {
        this.roles = roles;
    }

    public void setMtlsRestricted(boolean isMtlsRestricted) {
        this.mtlsRestricted = isMtlsRestricted;
    }

    public void setState(Principal.State state) {
        this.state = state;
    }

    @Override
    public String getIP() {
        return this.ip;
    }

    @Override
    public String getUnsignedCredentials() {
        return this.unsignedCreds;
    }

    @Override
    public Authority getAuthority() {
        return this.authority;
    }

    @Override
    public String getDomain() {
        return this.domain;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getOriginalRequestor() {
        return this.originalRequestor;
    }

    @Override
    public String getFullName() {
        if (this.fullName == null) {
            this.fullName = this.domain != null && this.name != null ? this.domain + "." + this.name : (this.name != null ? this.name : this.domain);
        }
        return this.fullName;
    }

    @Override
    public String getCredentials() {
        return this.creds;
    }

    @Override
    public List<String> getRoles() {
        return this.roles;
    }

    @Override
    public long getIssueTime() {
        return this.issueTime;
    }

    public String toString() {
        if (this.roles == null) {
            return this.domain + "." + this.name;
        }
        return "ZToken_" + this.domain + "~" + this.roles.toString().replace("[", "").replace("]", "");
    }

    @Override
    public String getAuthorizedService() {
        return this.authorizedService;
    }

    @Override
    public String getKeyService() {
        return this.keyService;
    }

    @Override
    public String getKeyId() {
        return this.keyId;
    }

    @Override
    public X509Certificate getX509Certificate() {
        return this.x509Certificate;
    }

    @Override
    public String getApplicationId() {
        return this.applicationId;
    }

    @Override
    public boolean getMtlsRestricted() {
        return this.mtlsRestricted;
    }

    @Override
    public Principal.State getState() {
        return this.state;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimplePrincipal that = (SimplePrincipal)o;
        return this.getFullName().equals(that.getFullName());
    }

    public int hashCode() {
        return Objects.hash(this.getFullName());
    }
}

