/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.athenz.auth.impl;

import com.yahoo.athenz.auth.Authority;
import com.yahoo.athenz.auth.AuthorityKeyStore;
import com.yahoo.athenz.auth.KeyStore;
import com.yahoo.athenz.auth.Principal;
import com.yahoo.athenz.auth.impl.SimplePrincipal;
import com.yahoo.athenz.auth.token.RoleToken;
import com.yahoo.athenz.auth.token.Token;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoleAuthority
implements Authority,
AuthorityKeyStore {
    private static final Logger LOG = LoggerFactory.getLogger(RoleAuthority.class);
    public static final String SYS_AUTH_DOMAIN = "sys.auth";
    public static final String ZTS_SERVICE_NAME = "zts";
    private static final String USER_DOMAIN = "user";
    static final String ATHENZ_PROP_TOKEN_OFFSET = "athenz.auth.role.token_allowed_offset";
    static final String ATHENZ_PROP_USER_DOMAIN = "athenz.user_domain";
    public static final String HTTP_HEADER = "Athenz-Role-Auth";
    public static final String ATHENZ_AUTH_CHALLENGE = "AthenzRoleToken realm=\"athenz\"";
    public static final String ATHENZ_PROP_ROLE_HEADER = "athenz.auth.role.header";
    private int allowedOffset = Integer.parseInt(System.getProperty("athenz.auth.role.token_allowed_offset", "300"));
    private KeyStore keyStore = null;
    String userDomain = System.getProperty("athenz.user_domain", "user");
    String headerName = System.getProperty("athenz.auth.role.header", "Athenz-Role-Auth");

    public RoleAuthority() {
        if (this.allowedOffset < 0) {
            this.allowedOffset = 300;
        }
    }

    @Override
    public String getID() {
        return "Auth-ROLE";
    }

    @Override
    public void initialize() {
    }

    @Override
    public String getDomain() {
        return SYS_AUTH_DOMAIN;
    }

    @Override
    public String getHeader() {
        return this.headerName;
    }

    @Override
    public String getAuthenticateChallenge() {
        return ATHENZ_AUTH_CHALLENGE;
    }

    @Override
    public Principal authenticate(String signedToken, String remoteAddr, String httpMethod, StringBuilder errMsg) {
        String publicKey;
        RoleToken roleToken;
        StringBuilder stringBuilder = errMsg = errMsg == null ? new StringBuilder(512) : errMsg;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Authenticating RoleToken: {}", (Object)signedToken);
        }
        try {
            roleToken = new RoleToken(signedToken);
        }
        catch (IllegalArgumentException ex) {
            errMsg.append("RoleAuthority:authenticate failed: Invalid token: exc=").append(ex.getMessage()).append(" : credential=").append(Token.getUnsignedToken(signedToken));
            LOG.error(errMsg.toString());
            return null;
        }
        if (!remoteAddr.equals(roleToken.getIP()) && this.isWriteOperation(httpMethod)) {
            String tokenPrincipal = roleToken.getPrincipal();
            int idx = tokenPrincipal.lastIndexOf(46);
            if (idx <= 0 || idx == tokenPrincipal.length() - 1) {
                errMsg.append("RoleAuthority:authenticate failed: Invalid principal specified: ").append(tokenPrincipal).append(" : credential=").append(Token.getUnsignedToken(signedToken));
                LOG.error(errMsg.toString());
                return null;
            }
            if (tokenPrincipal.substring(0, idx).equalsIgnoreCase(this.userDomain)) {
                errMsg.append("RoleAuthority:authenticate failed: IP Mismatch - token-ip(").append(roleToken.getIP()).append(") request-addr(").append(remoteAddr).append(") : credential=").append(Token.getUnsignedToken(signedToken));
                if (LOG.isWarnEnabled()) {
                    LOG.warn(errMsg.toString());
                }
                return null;
            }
        }
        if (!roleToken.validate(publicKey = this.keyStore.getPublicKey(SYS_AUTH_DOMAIN, ZTS_SERVICE_NAME, roleToken.getKeyId()), this.allowedOffset, false)) {
            errMsg.append("RoleAuthority:authenticate failed: validation was not successful: credential=").append(Token.getUnsignedToken(signedToken));
            if (LOG.isWarnEnabled()) {
                LOG.warn(errMsg.toString());
            }
            return null;
        }
        SimplePrincipal princ = (SimplePrincipal)SimplePrincipal.create(roleToken.getDomain().toLowerCase(), signedToken, roleToken.getRoles(), (Authority)this);
        princ.setUnsignedCreds(roleToken.getUnsignedToken());
        return princ;
    }

    boolean isWriteOperation(String httpMethod) {
        if (httpMethod == null) {
            return false;
        }
        return httpMethod.equalsIgnoreCase("PUT") || httpMethod.equalsIgnoreCase("POST") || httpMethod.equalsIgnoreCase("DELETE");
    }

    @Override
    public void setKeyStore(KeyStore keyStore) {
        this.keyStore = keyStore;
    }
}

