/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.athenz.auth.impl;

import com.yahoo.athenz.auth.Authority;
import com.yahoo.athenz.auth.AuthorityKeyStore;
import com.yahoo.athenz.auth.KeyStore;
import com.yahoo.athenz.auth.Principal;
import com.yahoo.athenz.auth.impl.SimplePrincipal;
import com.yahoo.athenz.auth.token.PrincipalToken;
import com.yahoo.athenz.auth.token.Token;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrincipalAuthority
implements Authority,
AuthorityKeyStore {
    private static final String USER_DOMAIN = "user";
    private static final String SYS_AUTH_DOMAIN = "sys.auth";
    private static final String ZMS_SERVICE = "zms";
    private static final String ZTS_SERVICE = "zts";
    static final String ATHENZ_PROP_TOKEN_OFFSET = "athenz.auth.principal.token_allowed_offset";
    private static final String ATHENZ_PROP_IP_CHECK_MODE = "athenz.auth.principal.remote_ip_check_mode";
    private static final String ATHENZ_PROP_USER_DOMAIN = "athenz.user_domain";
    public static final String HTTP_HEADER = "Athenz-Principal-Auth";
    public static final String ATHENZ_AUTH_CHALLENGE = "AthenzPrincipalToken realm=\"athenz\"";
    public static final String ATHENZ_PROP_PRINCIPAL_HEADER = "athenz.auth.principal.header";
    private static final Logger LOG = LoggerFactory.getLogger(PrincipalAuthority.class);
    private KeyStore keyStore = null;
    private int allowedOffset = Integer.parseInt(System.getProperty("athenz.auth.principal.token_allowed_offset", "300"));
    IpCheckMode ipCheckMode = IpCheckMode.valueOf(System.getProperty("athenz.auth.principal.remote_ip_check_mode", IpCheckMode.OPS_WRITE.toString()));
    final String userDomain = System.getProperty("athenz.user_domain", "user");
    private String headerName = System.getProperty("athenz.auth.principal.header", "Athenz-Principal-Auth");

    public PrincipalAuthority() {
        if (this.allowedOffset < 0) {
            this.allowedOffset = 300;
        }
    }

    @Override
    public String getID() {
        return "Auth-NTOKEN";
    }

    @Override
    public void initialize() {
    }

    @Override
    public String getDomain() {
        return null;
    }

    @Override
    public String getHeader() {
        return this.headerName;
    }

    @Override
    public String getAuthenticateChallenge() {
        return ATHENZ_AUTH_CHALLENGE;
    }

    @Override
    public Principal authenticate(String signedToken, String remoteAddr, String httpMethod, StringBuilder errMsg) {
        boolean writeOp;
        PrincipalToken serviceToken;
        StringBuilder stringBuilder = errMsg = errMsg == null ? new StringBuilder(512) : errMsg;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Authenticating PrincipalToken: {}", (Object)signedToken);
        }
        try {
            serviceToken = new PrincipalToken(signedToken);
        }
        catch (IllegalArgumentException ex) {
            errMsg.append("PrincipalAuthority:authenticate: Invalid token: exc=").append(ex.getMessage()).append(" : credential=").append(Token.getUnsignedToken(signedToken));
            LOG.error(errMsg.toString());
            return null;
        }
        StringBuilder errDetail = new StringBuilder(512);
        if (!serviceToken.isValidAuthorizedServiceToken(errDetail)) {
            errMsg.append("PrincipalAuthority:authenticate: Invalid authorized service token: ");
            errMsg.append((CharSequence)errDetail).append(" : credential=").append(Token.getUnsignedToken(signedToken));
            return null;
        }
        String tokenDomain = serviceToken.getDomain().toLowerCase();
        String tokenName = serviceToken.getName().toLowerCase();
        String keyService = serviceToken.getKeyService();
        boolean userToken = tokenDomain.equals(this.userDomain);
        String publicKey = this.getPublicKey(tokenDomain, tokenName, keyService, serviceToken.getKeyId(), userToken);
        if (!serviceToken.validate(publicKey, this.allowedOffset, !(writeOp = this.isWriteOperation(httpMethod)), errDetail)) {
            errMsg.append("PrincipalAuthority:authenticate: service token validation failure: ");
            errMsg.append((CharSequence)errDetail).append(" : credential=").append(Token.getUnsignedToken(signedToken));
            return null;
        }
        String authorizedServiceName = null;
        if (serviceToken.getAuthorizedServiceSignature() != null && (authorizedServiceName = this.validateAuthorizeService(serviceToken, errDetail)) == null) {
            errMsg.append("PrincipalAuthority:authenticate: validation of authorized service failure: ").append((CharSequence)errDetail).append(" : credential=").append(Token.getUnsignedToken(signedToken));
            return null;
        }
        if (userToken && !this.remoteIpCheck(remoteAddr, writeOp, serviceToken, authorizedServiceName)) {
            errMsg.append("PrincipalAuthority:authenticate: IP Mismatch - token (").append(serviceToken.getIP()).append(") request (").append(remoteAddr).append(")");
            LOG.error(errMsg.toString());
            return null;
        }
        SimplePrincipal princ = (SimplePrincipal)SimplePrincipal.create(tokenDomain, tokenName, signedToken, serviceToken.getTimestamp(), this);
        princ.setUnsignedCreds(serviceToken.getUnsignedToken());
        princ.setAuthorizedService(authorizedServiceName);
        princ.setOriginalRequestor(serviceToken.getOriginalRequestor());
        princ.setKeyService(keyService);
        princ.setIP(serviceToken.getIP());
        princ.setKeyId(serviceToken.getKeyId());
        return princ;
    }

    boolean remoteIpCheck(String remoteAddr, boolean writeOp, PrincipalToken serviceToken, String authorizedServiceName) {
        boolean checkResult = true;
        switch (this.ipCheckMode) {
            case OPS_ALL: {
                if (remoteAddr.equals(serviceToken.getIP())) break;
                checkResult = false;
                break;
            }
            case OPS_WRITE: {
                if (!writeOp || remoteAddr.equals(serviceToken.getIP()) || authorizedServiceName != null) break;
                checkResult = false;
                break;
            }
        }
        return checkResult;
    }

    String getPublicKey(String tokenDomain, String tokenName, String keyService, String keyId, boolean userToken) {
        String publicKeyDomain = tokenDomain;
        String publicKeyService = tokenName;
        if (keyService != null && !keyService.isEmpty()) {
            if (keyService.equals(ZMS_SERVICE)) {
                publicKeyDomain = SYS_AUTH_DOMAIN;
                publicKeyService = ZMS_SERVICE;
            } else if (keyService.equals(ZTS_SERVICE)) {
                publicKeyDomain = SYS_AUTH_DOMAIN;
                publicKeyService = ZTS_SERVICE;
            }
        } else if (userToken) {
            publicKeyDomain = SYS_AUTH_DOMAIN;
            publicKeyService = ZMS_SERVICE;
        }
        return this.keyStore.getPublicKey(publicKeyDomain, publicKeyService, keyId);
    }

    boolean isWriteOperation(String httpMethod) {
        if (httpMethod == null) {
            return false;
        }
        return httpMethod.equalsIgnoreCase("PUT") || httpMethod.equalsIgnoreCase("POST") || httpMethod.equalsIgnoreCase("DELETE");
    }

    String getAuthorizedServiceName(List<String> authorizedServices, String authorizedServiceName) {
        String serviceName = authorizedServiceName;
        if (serviceName == null) {
            if (authorizedServices.size() != 1) {
                LOG.error("getAuthorizedServiceName() failed: No authorized service name specified");
                return null;
            }
            serviceName = authorizedServices.get(0);
        } else if (!authorizedServices.contains(serviceName)) {
            LOG.error("getAuthorizedServiceName() failed: Invalid authorized service name specified:" + serviceName);
            return null;
        }
        return serviceName;
    }

    String validateAuthorizeService(PrincipalToken userToken, StringBuilder errMsg) {
        StringBuilder errDetail;
        int idx;
        errMsg = errMsg == null ? new StringBuilder(512) : errMsg;
        String authorizedServiceName = userToken.getAuthorizedServiceName();
        if (authorizedServiceName == null) {
            List<String> authorizedServices = userToken.getAuthorizedServices();
            if (authorizedServices == null || authorizedServices.size() != 1) {
                errMsg.append("PrincipalAuthority:validateAuthorizeService: ").append("No service name and services list empty OR contains multiple entries: token=").append(userToken.getUnsignedToken());
                return null;
            }
            authorizedServiceName = authorizedServices.get(0);
        }
        if ((idx = authorizedServiceName.lastIndexOf(46)) <= 0 || idx == authorizedServiceName.length() - 1) {
            errMsg.append("PrincipalAuthority:validateAuthorizeService: ").append("failed: token=").append(userToken.getUnsignedToken()).append(" : Invalid authorized service name specified=").append(authorizedServiceName);
            LOG.error(errMsg.toString());
            return null;
        }
        String publicKey = this.keyStore.getPublicKey(authorizedServiceName.substring(0, idx), authorizedServiceName.substring(idx + 1), userToken.getAuthorizedServiceKeyId());
        if (!userToken.validateForAuthorizedService(publicKey, errDetail = new StringBuilder(512))) {
            errMsg.append("PrincipalAuthority:validateAuthorizeService: token validation for authorized service failed: ").append((CharSequence)errDetail);
            return null;
        }
        return authorizedServiceName;
    }

    @Override
    public void setKeyStore(KeyStore keyStore) {
        this.keyStore = keyStore;
    }

    static enum IpCheckMode {
        OPS_ALL,
        OPS_WRITE,
        OPS_NONE;

    }
}

