/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.athenz.auth.impl;

import com.yahoo.athenz.auth.Authority;
import com.yahoo.athenz.auth.Principal;
import com.yahoo.athenz.auth.impl.SimplePrincipal;
import java.util.Base64;
import java.util.Hashtable;
import javax.naming.AuthenticationException;
import javax.naming.AuthenticationNotSupportedException;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LDAPAuthority
implements Authority {
    private static final Logger LOG = LoggerFactory.getLogger(LDAPAuthority.class);
    static final String ATHENZ_PROP_LDAP_BASE_DN = "athenz.auth.ldap.base_dn";
    static final String ATHENZ_PROP_LDAP_PORT = "athenz.auth.ldap.port";
    static final String ATHENZ_AUTH_CHALLENGE = "LDAPAuthentication realm=\"athenz\"";
    static final String ATHENZ_PROP_HOSTNAME = "athenz.auth.ldap.hostname";
    private String baseDN;
    private String portNumber;
    private String hostName;
    private String providerURL;

    @Override
    public void initialize() {
        this.baseDN = System.getProperty(ATHENZ_PROP_LDAP_BASE_DN, "o=Athenz");
        this.portNumber = System.getProperty(ATHENZ_PROP_LDAP_PORT, "389");
        this.hostName = System.getProperty(ATHENZ_PROP_HOSTNAME, "localhost");
        this.providerURL = "ldap://" + this.hostName + ":" + this.portNumber;
    }

    @Override
    public String getID() {
        return "Auth-LDAP";
    }

    @Override
    public String getDomain() {
        return "user";
    }

    @Override
    public String getHeader() {
        return "Authorization";
    }

    @Override
    public String getAuthenticateChallenge() {
        return ATHENZ_AUTH_CHALLENGE;
    }

    @Override
    public boolean allowAuthorization() {
        return false;
    }

    @Override
    public Principal authenticate(String creds, String remoteAddr, String httpMethod, StringBuilder errMsg) {
        String decodedCreds;
        if (!creds.startsWith("Basic ")) {
            errMsg.append("LDAPAuthority: authenticate: credentials do not start with 'Basic '");
            LOG.error(errMsg.toString());
            return null;
        }
        String encodedCreds = creds.substring(6);
        try {
            decodedCreds = new String(Base64.getDecoder().decode(encodedCreds));
        }
        catch (Exception e) {
            errMsg.append("LDAPAuthority: authenticate: factory exc=").append(e.getMessage());
            LOG.error(errMsg.toString());
            return null;
        }
        int idx = decodedCreds.indexOf(58);
        if (idx == -1) {
            errMsg.append("LDAPAuthority: authenticate: no password specified");
            LOG.error(errMsg.toString());
            return null;
        }
        String username = decodedCreds.substring(0, idx);
        String password = decodedCreds.substring(idx + 1);
        String finalDN = "cn=" + username + "," + this.baseDN;
        try {
            DirContext ctx = this.getDirContext(finalDN, password);
            ctx.close();
        }
        catch (AuthenticationException e) {
            errMsg.append("LDAPAuthority: failed: Wrong credentials");
            LOG.error(errMsg.toString());
            return null;
        }
        catch (AuthenticationNotSupportedException e) {
            errMsg.append("LDAPAuthority: failed: Authentication method not supported");
            LOG.error(errMsg.toString());
            return null;
        }
        catch (NamingException e) {
            errMsg.append("LDAPAuthority: failed: ").append(e.getMessage());
            LOG.error(errMsg.toString());
            return null;
        }
        SimplePrincipal simplePrincipal = this.getSimplePrincipal(creds, username);
        if (simplePrincipal == null) {
            errMsg.append("LDAPAuthority:authenticate: failed to create principal: user=").append(username);
            LOG.error(errMsg.toString());
            return null;
        }
        simplePrincipal.setUnsignedCreds(username);
        return simplePrincipal;
    }

    DirContext getDirContext(String finalDN, String password) throws NamingException {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", this.providerURL);
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.security.principal", finalDN);
        env.put("java.naming.security.credentials", password);
        return new InitialDirContext(env);
    }

    SimplePrincipal getSimplePrincipal(String creds, String username) {
        SimplePrincipal simplePrincipal = (SimplePrincipal)SimplePrincipal.create(this.getDomain(), username.toLowerCase(), creds, (Authority)this);
        return simplePrincipal;
    }
}

