/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.athenz.auth.impl;

import com.yahoo.athenz.auth.Authority;
import com.yahoo.athenz.auth.Principal;
import com.yahoo.athenz.auth.impl.SimplePrincipal;
import com.yahoo.athenz.auth.token.KerberosToken;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.kerberos.KerberosTicket;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KerberosAuthority
implements Authority {
    private static final Logger LOG = LoggerFactory.getLogger(KerberosAuthority.class);
    static final String KRB_AUTH_HEADER = "Authorization";
    static final String KRB_AUTH_CHALLENGE = "Negotiate";
    static final String KRB_PROP_SVCPRPL = "athenz.auth.kerberos.service_principal";
    static final String KRB_PROP_KEYTAB = "athenz.auth.kerberos.keytab_location";
    static final String KRB_PROP_DEBUG = "athenz.auth.kerberos.debug";
    static final String KRB_PROP_JAASCFG = "athenz.auth.kerberos.jaas_cfg_section";
    static final String KRB_PROP_LOGIN_CB_CLASS = "athenz.auth.kerberos.login_callback_handler_class";
    static final String KRB_PROP_LOGIN_RENEW_TGT = "athenz.auth.kerberos.renewTGT";
    static final String KRB_PROP_LOGIN_USE_TKT_CACHE = "athenz.auth.kerberos.use_ticket_cache";
    static final String KRB_PROP_LOGIN_TKT_CACHE_NAME = "athenz.auth.kerberos.ticket_cache_name";
    static final String KRB_PROP_LOGIN_WINDOW = "athenz.auth.kerberos.login_window";
    static final String LOGIN_WINDOW_DEF = "60000";
    private String servicePrincipal;
    private String keyTabConfFile;
    private String jaasConfigSection;
    private String loginCallbackHandler;
    private AtomicReference<Subject> serviceSubject = new AtomicReference();
    private Exception initState = null;
    private long lastLogin = 0L;
    private long loginWindow = 60000L;

    public KerberosAuthority(String servicePrincipal, String keyTabConfFile, String jaasConfigSection) {
        this();
        if (servicePrincipal != null) {
            this.servicePrincipal = servicePrincipal;
        }
        if (keyTabConfFile != null) {
            this.keyTabConfFile = keyTabConfFile;
        }
        this.jaasConfigSection = jaasConfigSection == null ? "" : jaasConfigSection;
    }

    public KerberosAuthority() {
        this.servicePrincipal = System.getProperty(KRB_PROP_SVCPRPL);
        this.keyTabConfFile = System.getProperty(KRB_PROP_KEYTAB);
        this.jaasConfigSection = System.getProperty(KRB_PROP_JAASCFG, "");
        this.loginCallbackHandler = System.getProperty(KRB_PROP_LOGIN_CB_CLASS);
        this.loginWindow = Long.decode(System.getProperty(KRB_PROP_LOGIN_WINDOW, LOGIN_WINDOW_DEF));
    }

    public Exception getInitState() {
        return this.initState;
    }

    public void setInitState(Exception exc) {
        this.initState = exc;
    }

    public long getLoginWindow() {
        return this.loginWindow;
    }

    public void setLoginWindow(long loginWindowMillis) {
        this.loginWindow = loginWindowMillis;
    }

    public long getLastLogin() {
        return this.lastLogin;
    }

    @Override
    public void initialize() {
        this.login(false);
    }

    @Override
    public String getID() {
        return "Auth-KERB";
    }

    public synchronized void login(boolean logoutFirst) {
        long now = System.currentTimeMillis();
        if (now - this.lastLogin < this.loginWindow) {
            return;
        }
        Subject subject = null;
        if (this.servicePrincipal != null) {
            HashSet<KerberosPrincipal> principals = new HashSet<KerberosPrincipal>(1);
            principals.add(new KerberosPrincipal(this.servicePrincipal));
            subject = new Subject(false, principals, new HashSet(), new HashSet());
        }
        LoginConfig loginConfig = new LoginConfig(this.keyTabConfFile, this.servicePrincipal);
        this.initState = null;
        try {
            CallbackHandler loginHandler = null;
            if (this.loginCallbackHandler != null) {
                Class<?> cbhandlerClass = Class.forName(this.loginCallbackHandler);
                loginHandler = (CallbackHandler)cbhandlerClass.getConstructor(String.class, String.class).newInstance(this.servicePrincipal, null);
            }
            LoginContext loginContext = subject == null ? new LoginContext(this.jaasConfigSection, Objects.requireNonNull(loginHandler)) : new LoginContext(this.jaasConfigSection, subject, loginHandler, loginConfig);
            if (logoutFirst) {
                loginContext.logout();
            }
            loginContext.login();
            subject = loginContext.getSubject();
            this.serviceSubject.set(subject);
            this.lastLogin = System.currentTimeMillis();
        }
        catch (Exception exc) {
            this.initState = exc;
            String params = "svc-princ=" + this.servicePrincipal + " login-callback=" + this.loginCallbackHandler + " keytab=" + this.keyTabConfFile + " jaas-section=" + this.jaasConfigSection;
            LOG.error("KerberosAuthority:initialize: Login context failure: config params=({}) exc: {}", (Object)params, (Object)exc.getMessage());
        }
    }

    boolean isTargetPrincipal(KerberosTicket ticket, String remoteSvcPrincipal) {
        if (ticket == null) {
            return false;
        }
        KerberosPrincipal principal = ticket.getServer();
        if (LOG.isDebugEnabled()) {
            LOG.debug("KerberosAuthority:isTargetPrincipal: our princ={} ticket princ={}", (Object)this.servicePrincipal, (Object)principal.getName());
        }
        return principal.getName().equals(remoteSvcPrincipal);
    }

    public boolean refreshLogin(String remoteSvcPrincipal) {
        Subject subject = this.serviceSubject.get();
        KerberosTicket tgt = null;
        Set<KerberosTicket> tickets = subject.getPrivateCredentials(KerberosTicket.class);
        for (KerberosTicket ticket : tickets) {
            if (!this.isTargetPrincipal(ticket, remoteSvcPrincipal)) continue;
            tgt = ticket;
            break;
        }
        if (tgt == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("KerberosAuthority:refreshLogin: Process tickets found no principal match: subject contains number of tickets={}", (Object)tickets.size());
            }
            return true;
        }
        long end = tgt.getEndTime().getTime();
        long now = System.currentTimeMillis();
        if (now > end) {
            this.login(true);
            return true;
        }
        return false;
    }

    @Override
    public String getDomain() {
        return null;
    }

    @Override
    public String getHeader() {
        return KRB_AUTH_HEADER;
    }

    @Override
    public String getAuthenticateChallenge() {
        return KRB_AUTH_CHALLENGE;
    }

    @Override
    public Principal authenticate(String creds, String remoteAddr, String httpMethod, StringBuilder errMsg) {
        KerberosToken token;
        try {
            token = new KerberosToken(creds, remoteAddr);
        }
        catch (IllegalArgumentException ex) {
            if (errMsg == null) {
                errMsg = new StringBuilder();
            }
            errMsg.append("KerberosAuthority:authenticate: Invalid token: exc=").append(ex.getMessage()).append(" : credential=").append(creds);
            LOG.error("KerberosAuthority:authenticate: {}", (Object)errMsg.toString());
            return null;
        }
        StringBuilder errDetail = new StringBuilder(512);
        if (!token.validate(this.serviceSubject.get(), errDetail)) {
            if (errMsg != null) {
                errMsg.append("KerberosAuthority:authenticate: token validation failure: ");
                errMsg.append((CharSequence)errDetail);
            }
            return null;
        }
        String userDomain = token.getDomain();
        String userName = token.getUserName();
        if (userName == null) {
            if (errMsg != null) {
                errMsg.append("KerberosAuthority:authenticate: token validation failure: missing user");
            }
            return null;
        }
        return SimplePrincipal.create(userDomain, userName, creds, (Authority)this);
    }

    static class LoginConfig
    extends Configuration {
        private String keyTabConfFile;
        private String servicePrincipalName;
        private boolean debugKrbEnabled;

        public LoginConfig(String keyTabConfFile, String servicePrincipalName) {
            this.keyTabConfFile = keyTabConfFile;
            this.servicePrincipalName = servicePrincipalName;
            this.debugKrbEnabled = Boolean.parseBoolean(System.getProperty(KerberosAuthority.KRB_PROP_DEBUG, "false"));
        }

        public boolean isDebugEnabled() {
            return this.debugKrbEnabled;
        }

        @Override
        public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
            HashMap<String, String> options = new HashMap<String, String>();
            if (this.keyTabConfFile == null || this.keyTabConfFile.isEmpty()) {
                options.put("useKeyTab", "false");
                options.put("tryFirstPass", "true");
            } else {
                options.put("useKeyTab", "true");
                options.put("keyTab", this.keyTabConfFile);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("KerberosAuthority:authenticate: use keytab={}", (Object)this.keyTabConfFile);
                }
            }
            options.put("principal", this.servicePrincipalName);
            options.put("storeKey", "true");
            options.put("doNotPrompt", "true");
            String useTktCache = System.getProperty(KerberosAuthority.KRB_PROP_LOGIN_USE_TKT_CACHE, "true");
            options.put("useTicketCache", useTktCache);
            String renewTgt = System.getProperty(KerberosAuthority.KRB_PROP_LOGIN_RENEW_TGT, "true");
            options.put("renewTGT", renewTgt);
            options.put("refreshKrb5Config", "true");
            if (Boolean.parseBoolean(useTktCache)) {
                String ticketCacheName = System.getenv("KRB5CCNAME");
                if (ticketCacheName != null) {
                    options.put("ticketCache", ticketCacheName);
                } else {
                    ticketCacheName = System.getProperty(KerberosAuthority.KRB_PROP_LOGIN_TKT_CACHE_NAME);
                    if (ticketCacheName != null) {
                        options.put("ticketCache", ticketCacheName);
                    }
                }
            }
            if (this.debugKrbEnabled) {
                options.put("debug", "true");
            }
            options.put("isInitiator", "false");
            return new AppConfigurationEntry[]{new AppConfigurationEntry("com.sun.security.auth.module.Krb5LoginModule", AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options)};
        }
    }
}

