/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.athenz.auth.impl;

import com.yahoo.athenz.auth.PrivateKeyStore;
import com.yahoo.athenz.auth.ServerPrivateKey;
import com.yahoo.athenz.auth.util.Crypto;
import java.io.File;
import java.security.PrivateKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilePrivateKeyStore
implements PrivateKeyStore {
    private static final Logger LOG = LoggerFactory.getLogger(FilePrivateKeyStore.class);
    public static final String ATHENZ_PROP_PRIVATE_KEY = "athenz.auth.private_key_store.private_key";
    public static final String ATHENZ_PROP_PRIVATE_KEY_ID = "athenz.auth.private_key_store.private_key_id";
    public static final String ATHENZ_PROP_PRIVATE_EC_KEY = "athenz.auth.private_key_store.private_ec_key";
    public static final String ATHENZ_PROP_PRIVATE_EC_KEY_ID = "athenz.auth.private_key_store.private_ec_key_id";
    public static final String ATHENZ_PROP_PRIVATE_RSA_KEY = "athenz.auth.private_key_store.private_rsa_key";
    public static final String ATHENZ_PROP_PRIVATE_RSA_KEY_ID = "athenz.auth.private_key_store.private_rsa_key_id";
    private static final String ZMS_SERVICE = "zms";
    private static final String ZTS_SERVICE = "zts";
    private static final String ALGO_RSA = "RSA";
    private static final String ALGO_EC = "EC";

    @Override
    public ServerPrivateKey getPrivateKey(String service, String serverHostName, String serverRegion, String algorithm) {
        String privKeyId;
        String privKeyName;
        if (!ZMS_SERVICE.equalsIgnoreCase(service) && !ZTS_SERVICE.equalsIgnoreCase(service)) {
            LOG.error("FilePrivateKeyStore: unknown service: {}", (Object)service);
            return null;
        }
        if (!ALGO_RSA.equalsIgnoreCase(algorithm) && !ALGO_EC.equalsIgnoreCase(algorithm)) {
            LOG.error("FilePrivateKeyStore: unknown algorithm: {}", (Object)algorithm);
            return null;
        }
        if (ALGO_RSA.equalsIgnoreCase(algorithm)) {
            privKeyName = System.getProperty(ATHENZ_PROP_PRIVATE_RSA_KEY);
            privKeyId = System.getProperty(ATHENZ_PROP_PRIVATE_RSA_KEY_ID, "0");
        } else {
            privKeyName = System.getProperty(ATHENZ_PROP_PRIVATE_EC_KEY);
            privKeyId = System.getProperty(ATHENZ_PROP_PRIVATE_EC_KEY_ID, "0");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("FilePrivateKeyStore: private key file: {}, id: {}", (Object)privKeyName, (Object)privKeyId);
        }
        if (privKeyName == null) {
            return null;
        }
        File privKeyFile = new File(privKeyName);
        PrivateKey pkey = Crypto.loadPrivateKey(privKeyFile);
        ServerPrivateKey privateKey = null;
        if (pkey != null) {
            privateKey = new ServerPrivateKey(pkey, privKeyId);
        }
        return privateKey;
    }

    @Override
    public PrivateKey getPrivateKey(String service, String serverHostName, StringBuilder privateKeyId) {
        String privKeyName = System.getProperty(ATHENZ_PROP_PRIVATE_KEY);
        if (LOG.isDebugEnabled()) {
            LOG.debug("FilePrivateKeyStore: private key file={}", (Object)privKeyName);
        }
        if (privKeyName == null) {
            return null;
        }
        File privKeyFile = new File(privKeyName);
        PrivateKey pkey = Crypto.loadPrivateKey(privKeyFile);
        if (pkey != null) {
            privateKeyId.append(System.getProperty(ATHENZ_PROP_PRIVATE_KEY_ID, "0"));
        }
        return pkey;
    }
}

