/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.athenz.auth.impl;

import com.yahoo.athenz.auth.impl.CertificateIdentity;
import com.yahoo.athenz.auth.impl.CertificateIdentityException;
import com.yahoo.athenz.auth.util.AthenzUtils;
import com.yahoo.athenz.auth.util.Crypto;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class CertificateIdentityParser {
    public static final String JAVAX_CERT_ATTR = "javax.servlet.request.X509Certificate";
    public static final String EMPTY_CERT_ERR_MSG = "No certificate available in request";
    private Set<String> excludedPrincipalSet = null;
    private boolean excludeRoleCertificates;

    public CertificateIdentityParser(Set<String> excludedPrincipalSet, boolean excludeRoleCertificates) {
        this.excludedPrincipalSet = excludedPrincipalSet;
        this.excludeRoleCertificates = excludeRoleCertificates;
    }

    public CertificateIdentity parse(HttpServletRequest request) throws CertificateIdentityException {
        X509Certificate[] certs = (X509Certificate[])request.getAttribute(JAVAX_CERT_ATTR);
        return this.parse(certs);
    }

    public CertificateIdentity parse(X509Certificate[] certs) throws CertificateIdentityException {
        if (certs == null || certs[0] == null) {
            throw new CertificateIdentityException(EMPTY_CERT_ERR_MSG);
        }
        X509Certificate x509Cert = certs[0];
        String principalName = Crypto.extractX509CertCommonName(x509Cert);
        if (principalName == null || principalName.isEmpty()) {
            throw new CertificateIdentityException("Certificate principal is empty");
        }
        if (this.excludedPrincipalSet != null && this.excludedPrincipalSet.contains(principalName)) {
            throw new CertificateIdentityException("Principal is excluded");
        }
        ArrayList<String> roles = null;
        int idx = principalName.indexOf(":role.");
        if (idx != -1) {
            if (this.excludeRoleCertificates) {
                throw new CertificateIdentityException("Role Certificates not allowed");
            }
            roles = new ArrayList<String>();
            roles.add(principalName);
            List<String> emails = Crypto.extractX509CertEmails(x509Cert);
            if (emails.isEmpty()) {
                throw new CertificateIdentityException("Invalid role cert, no email SAN entry");
            }
            String email = emails.get(0);
            idx = email.indexOf(64);
            if (idx == -1) {
                throw new CertificateIdentityException("Invalid role cert, invalid email SAN entry");
            }
            principalName = email.substring(0, idx);
        }
        if (this.excludeRoleCertificates && roles != null) {
            throw new CertificateIdentityException("Role Certificates not allowed");
        }
        String[] ds = AthenzUtils.splitPrincipalName(principalName);
        if (ds == null) {
            throw new CertificateIdentityException("Principal is not a valid service identity");
        }
        return new CertificateIdentity(ds[0], ds[1], roles, x509Cert);
    }
}

