/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.athenz.auth.impl;

import com.yahoo.athenz.auth.util.AthenzUtils;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.stream.Collectors;

public class CertificateIdentity {
    private String domain = null;
    private String service = null;
    private List<String> roles = null;
    private X509Certificate x509Certificate = null;

    public CertificateIdentity(String domain, String service, List<String> roles, X509Certificate x509Certificate) {
        this.domain = domain;
        this.service = service;
        this.roles = roles;
        this.x509Certificate = x509Certificate;
    }

    public String getPrincipalName() {
        return AthenzUtils.getPrincipalName(this.domain, this.service);
    }

    public String getDomain() {
        return this.domain;
    }

    public String getService() {
        return this.service;
    }

    public List<String> getRoles() {
        return this.roles;
    }

    public X509Certificate getX509Certificate() {
        return this.x509Certificate;
    }

    public String toString() {
        return "{domain:\"" + this.getDomain() + "\", service:\"" + this.getService() + "\", roles:[" + this.getRoles().stream().map(r -> '\"' + r + '\"').collect(Collectors.joining(", ")) + "], x509Cert:\"" + this.getX509Certificate().toString() + "\"}";
    }
}

