/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.athenz.auth.impl;

import com.yahoo.athenz.auth.Authority;
import com.yahoo.athenz.auth.Principal;
import com.yahoo.athenz.auth.impl.CertificateIdentity;
import com.yahoo.athenz.auth.impl.CertificateIdentityException;
import com.yahoo.athenz.auth.impl.CertificateIdentityParser;
import com.yahoo.athenz.auth.impl.SimplePrincipal;
import com.yahoo.athenz.auth.util.Crypto;
import com.yahoo.athenz.auth.util.GlobStringsMatcher;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertificateAuthority
implements Authority {
    private static final Logger LOG = LoggerFactory.getLogger(CertificateAuthority.class);
    private static final String ATHENZ_PROP_EXCLUDED_PRINCIPALS = "athenz.auth.certificate.excluded_principals";
    private static final String ATHENZ_PROP_EXCLUDE_ROLE_CERTIFICATES = "athenz.auth.certificate.exclude_role_certificates";
    private static final String ATHENZ_AUTH_CHALLENGE = "AthenzX509Certificate realm=\"athenz\"";
    private CertificateIdentityParser certificateIdentityParser = null;
    private GlobStringsMatcher globStringsMatcher = new GlobStringsMatcher("athenz.crypto.restricted_ou");

    @Override
    public void initialize() {
        HashSet<String> excludedPrincipalSet = null;
        String exPrincipals = System.getProperty(ATHENZ_PROP_EXCLUDED_PRINCIPALS);
        if (exPrincipals != null && !exPrincipals.isEmpty()) {
            excludedPrincipalSet = new HashSet<String>(Arrays.asList(exPrincipals.split(",")));
        }
        boolean excludeRoleCertificates = Boolean.parseBoolean(System.getProperty(ATHENZ_PROP_EXCLUDE_ROLE_CERTIFICATES, "false"));
        this.certificateIdentityParser = new CertificateIdentityParser(excludedPrincipalSet, excludeRoleCertificates);
    }

    @Override
    public String getID() {
        return "Auth-X509";
    }

    @Override
    public String getDomain() {
        return null;
    }

    @Override
    public String getHeader() {
        return null;
    }

    @Override
    public String getAuthenticateChallenge() {
        return ATHENZ_AUTH_CHALLENGE;
    }

    @Override
    public Principal authenticate(String creds, String remoteAddr, String httpMethod, StringBuilder errMsg) {
        return null;
    }

    @Override
    public Authority.CredSource getCredSource() {
        return Authority.CredSource.CERTIFICATE;
    }

    void reportError(String message, StringBuilder errMsg) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(message);
        }
        if (errMsg != null) {
            errMsg.append(message);
        }
    }

    @Override
    public Principal authenticate(X509Certificate[] certs, StringBuilder errMsg) {
        if (LOG.isDebugEnabled() && certs != null) {
            for (X509Certificate cert : certs) {
                LOG.debug("CertificateAuthority: TLS Certificate: {}", (Object)cert);
            }
        }
        CertificateIdentity certId = null;
        try {
            certId = this.certificateIdentityParser.parse(certs);
        }
        catch (CertificateIdentityException e) {
            this.reportError("CertificateAuthority: " + e.getMessage(), errMsg);
            return null;
        }
        X509Certificate x509Cert = certId.getX509Certificate();
        SimplePrincipal principal = (SimplePrincipal)SimplePrincipal.create(certId.getDomain(), certId.getService(), x509Cert.toString(), (Authority)this);
        principal.setUnsignedCreds(x509Cert.getSubjectX500Principal().toString());
        principal.setX509Certificate(x509Cert);
        principal.setRoles(certId.getRoles());
        principal.setMtlsRestricted(Crypto.isRestrictedCertificate(x509Cert, this.globStringsMatcher));
        return principal;
    }
}

