/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.athenz.auth;

import com.yahoo.athenz.auth.Authority;
import java.security.cert.X509Certificate;
import java.util.List;

public interface Principal {
    public String getDomain();

    public String getName();

    public String getFullName();

    public String getCredentials();

    default public X509Certificate getX509Certificate() {
        return null;
    }

    public String getUnsignedCredentials();

    public List<String> getRoles();

    public Authority getAuthority();

    public long getIssueTime();

    public String getAuthorizedService();

    default public String getIP() {
        return null;
    }

    default public String getOriginalRequestor() {
        return null;
    }

    default public String getKeyService() {
        return null;
    }

    default public String getKeyId() {
        return null;
    }

    default public String getApplicationId() {
        return null;
    }

    default public boolean getMtlsRestricted() {
        return false;
    }

    default public State getState() {
        return State.ACTIVE;
    }

    public static enum State {
        ACTIVE(0),
        AUTHORITY_FILTER_DISABLED(1),
        AUTHORITY_SYSTEM_SUSPENDED(2);

        private final int principalState;

        private State(int state) {
            this.principalState = state;
        }

        public int getValue() {
            return this.principalState;
        }

        public static State getState(int value) {
            for (State state : State.values()) {
                if (state.getValue() != value) continue;
                return state;
            }
            return ACTIVE;
        }
    }

    public static enum Type {
        UNKNOWN(0),
        USER(1),
        SERVICE(2),
        GROUP(3);

        private final int principalType;

        private Type(int type) {
            this.principalType = type;
        }

        public int getValue() {
            return this.principalType;
        }

        public static Type getType(int value) {
            for (Type type : Type.values()) {
                if (type.getValue() != value) continue;
                return type;
            }
            return UNKNOWN;
        }
    }
}

