/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.athenz.auth;

import com.yahoo.athenz.auth.Principal;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public interface Authority {
    public void initialize();

    default public String getID() {
        return "Auth-ID";
    }

    default public CredSource getCredSource() {
        return CredSource.HEADER;
    }

    public String getDomain();

    public String getHeader();

    default public String getAuthenticateChallenge() {
        return null;
    }

    default public boolean allowAuthorization() {
        return true;
    }

    default public String getUserDomainName(String userName) {
        return userName;
    }

    default public boolean isValidUser(String username) {
        return true;
    }

    public Principal authenticate(String var1, String var2, String var3, StringBuilder var4);

    default public Principal authenticate(X509Certificate[] certs, StringBuilder errMsg) {
        return null;
    }

    default public Principal authenticate(HttpServletRequest request, StringBuilder errMsg) {
        return null;
    }

    default public boolean isAttributeSet(String username, String attribute) {
        return false;
    }

    default public Set<String> booleanAttributesSupported() {
        return Collections.emptySet();
    }

    default public Date getDateAttribute(String username, String attribute) {
        return null;
    }

    default public Set<String> dateAttributesSupported() {
        return Collections.emptySet();
    }

    default public String getUserEmail(String username) {
        return null;
    }

    default public List<Principal> getPrincipals(EnumSet<Principal.State> principalStates) {
        return Collections.emptyList();
    }

    public static enum CredSource {
        HEADER,
        CERTIFICATE,
        REQUEST;

    }
}

