/*
 * Decompiled with CFR 0.152.
 */
package com.ximpleware.extended;

import com.ximpleware.extended.FastIntBuffer;
import com.ximpleware.extended.NavExceptionHuge;
import com.ximpleware.extended.VTDNavHuge;
import com.ximpleware.extended.XPathEvalExceptionHuge;
import com.ximpleware.extended.xpath.Expr;

public class BinaryExpr
extends Expr {
    public static final int ADD = 0;
    public static final int SUB = 1;
    public static final int MULT = 2;
    public static final int DIV = 3;
    public static final int MOD = 4;
    public static final int OR = 5;
    public static final int AND = 6;
    public static final int EQ = 7;
    public static final int NE = 8;
    public static final int LE = 9;
    public static final int GE = 10;
    public static final int LT = 11;
    public static final int GT = 12;
    public static final int BUF_SZ_EXP = 7;
    protected int op;
    boolean isNumerical;
    boolean isBoolean;
    protected Expr left;
    protected Expr right;
    protected FastIntBuffer fib1;

    public BinaryExpr(Expr l, int o, Expr r) {
        this.op = o;
        this.left = l;
        this.right = r;
        this.fib1 = null;
        switch (this.op) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.isNumerical = true;
                this.isBoolean = false;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                this.isNumerical = false;
                this.isBoolean = true;
            }
        }
    }

    @Override
    public String toString() {
        String os;
        switch (this.op) {
            case 0: {
                os = " + ";
                break;
            }
            case 1: {
                os = " - ";
                break;
            }
            case 2: {
                os = " * ";
                break;
            }
            case 3: {
                os = " / ";
                break;
            }
            case 4: {
                os = " mod ";
                break;
            }
            case 5: {
                os = " or ";
                break;
            }
            case 6: {
                os = " and ";
                break;
            }
            case 7: {
                os = " = ";
                break;
            }
            case 8: {
                os = " != ";
                break;
            }
            case 9: {
                os = " <= ";
                break;
            }
            case 10: {
                os = " >= ";
                break;
            }
            case 11: {
                os = " < ";
                break;
            }
            default: {
                os = " > ";
            }
        }
        return "(" + this.left + os + this.right + ")";
    }

    @Override
    public boolean evalBoolean(VTDNavHuge vn) {
        switch (this.op) {
            case 5: {
                return this.left.evalBoolean(vn) || this.right.evalBoolean(vn);
            }
            case 6: {
                return this.left.evalBoolean(vn) && this.right.evalBoolean(vn);
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                return this.computeComp(this.op, vn);
            }
        }
        double dval = this.evalNumber(vn);
        return dval != -0.0 && dval != 0.0 && !Double.isNaN(dval);
    }

    @Override
    public double evalNumber(VTDNavHuge vn) {
        switch (this.op) {
            case 0: {
                return this.left.evalNumber(vn) + this.right.evalNumber(vn);
            }
            case 1: {
                return this.left.evalNumber(vn) - this.right.evalNumber(vn);
            }
            case 2: {
                return this.left.evalNumber(vn) * this.right.evalNumber(vn);
            }
            case 3: {
                return this.left.evalNumber(vn) / this.right.evalNumber(vn);
            }
            case 4: {
                return this.left.evalNumber(vn) % this.right.evalNumber(vn);
            }
        }
        if (this.evalBoolean(vn)) {
            return 1.0;
        }
        return 0.0;
    }

    @Override
    public int evalNodeSet(VTDNavHuge vn) throws XPathEvalExceptionHuge {
        throw new XPathEvalExceptionHuge("BinaryExpr can't eval to a node set!");
    }

    @Override
    public String evalString(VTDNavHuge vn) {
        if (this.isNumerical()) {
            double d = this.evalNumber(vn);
            if (d == (double)((long)d)) {
                return "" + (long)d;
            }
            return "" + d;
        }
        boolean b = this.evalBoolean(vn);
        if (b) {
            return "true";
        }
        return "false";
    }

    @Override
    public void reset(VTDNavHuge vn) {
        this.left.reset(vn);
        this.right.reset(vn);
    }

    @Override
    public boolean isNodeSet() {
        return false;
    }

    @Override
    public boolean isNumerical() {
        return this.isNumerical;
    }

    @Override
    public boolean isString() {
        return false;
    }

    @Override
    public boolean isBoolean() {
        return this.isBoolean;
    }

    private boolean computeComp(int op, VTDNavHuge vn) {
        if (this.left.isNodeSet() && this.right.isNodeSet()) {
            return this.compNodeSetNodeSet(this.left, this.right, vn, op);
        }
        if (this.left.isNumerical() && this.right.isNodeSet()) {
            return this.compNumericalNodeSet(this.left, this.right, vn, op);
        }
        if (this.left.isNodeSet() && this.right.isNumerical()) {
            return this.compNodeSetNumerical(this.left, this.right, vn, op);
        }
        if (this.left.isString() && this.right.isNodeSet()) {
            return this.compStringNodeSet(this.left, this.right, vn, op);
        }
        if (this.left.isNodeSet() && this.right.isString()) {
            return this.compNodeSetString(this.left, this.right, vn, op);
        }
        if (op == 7 || op == 8) {
            if (this.left.isBoolean() || this.right.isBoolean()) {
                if (op == 7) {
                    return this.left.evalBoolean(vn) == this.right.evalBoolean(vn);
                }
                return this.left.evalBoolean(vn) != this.right.evalBoolean(vn);
            }
            if (this.left.isNumerical() || this.right.isNumerical()) {
                if (op == 7) {
                    return this.left.evalNumber(vn) == this.right.evalNumber(vn);
                }
                return this.left.evalNumber(vn) != this.right.evalNumber(vn);
            }
            String st1 = this.left.evalString(vn);
            String st2 = this.right.evalString(vn);
            return op == 7 ? st1.equals(st2) : !st1.equals(st2);
        }
        return this.compNumbers(this.left.evalNumber(vn), this.right.evalNumber(vn), op);
    }

    @Override
    public boolean requireContextSize() {
        return this.left.requireContextSize() || this.right.requireContextSize();
    }

    @Override
    public void setContextSize(int size) {
        this.left.setContextSize(size);
        this.right.setContextSize(size);
    }

    @Override
    public void setPosition(int pos) {
        this.left.setPosition(pos);
        this.right.setPosition(pos);
    }

    private boolean compNodeSetString(Expr left, Expr right, VTDNavHuge vn, int op) {
        int i1 = 0;
        try {
            int i;
            String s = right.evalString(vn);
            vn.push2();
            int stackSize = vn.contextStack2.size;
            while ((i = left.evalNodeSet(vn)) != -1) {
                boolean b;
                i1 = this.getStringVal(vn, i);
                if (i1 == -1 || !(b = this.compareVString1(i1, vn, s, op))) continue;
                left.reset(vn);
                vn.contextStack2.size = stackSize;
                vn.pop2();
                return b;
            }
            vn.contextStack2.size = stackSize;
            vn.pop2();
            left.reset(vn);
            return false;
        }
        catch (Exception e) {
            throw new RuntimeException("Undefined behavior");
        }
    }

    private boolean compareEmptyNodeSet(int op, String s) {
        if (op == 8) {
            return s.length() != 0;
        }
        return s.length() == 0;
    }

    private boolean compStringNodeSet(Expr left, Expr right, VTDNavHuge vn, int op) {
        int i1 = 0;
        try {
            int i;
            String s = left.evalString(vn);
            vn.push2();
            int stackSize = vn.contextStack2.size;
            while ((i = right.evalNodeSet(vn)) != -1) {
                boolean b;
                i1 = this.getStringVal(vn, i);
                if (i1 == -1 || !(b = this.compareVString2(i1, vn, s, op))) continue;
                right.reset(vn);
                vn.contextStack2.size = stackSize;
                vn.pop2();
                return b;
            }
            vn.contextStack2.size = stackSize;
            vn.pop2();
            right.reset(vn);
            return false;
        }
        catch (Exception e) {
            throw new RuntimeException("Undefined behavior");
        }
    }

    private boolean compNumbers(double d1, double d2, int op) {
        switch (op) {
            case 9: {
                return d1 <= d2;
            }
            case 10: {
                return d1 >= d2;
            }
            case 11: {
                return d1 < d2;
            }
            case 12: {
                return d1 > d2;
            }
        }
        return false;
    }

    private boolean compNumericalNodeSet(Expr left, Expr right, VTDNavHuge vn, int op) {
        int i1 = 0;
        try {
            int i;
            double d = left.evalNumber(vn);
            vn.push2();
            int stackSize = vn.contextStack2.size;
            while ((i = right.evalNodeSet(vn)) != -1) {
                i1 = this.getStringVal(vn, i);
                if (i1 == -1 || !this.compareVNumber1(i1, vn, d, op)) continue;
                right.reset(vn);
                vn.contextStack2.size = stackSize;
                vn.pop2();
                return true;
            }
            vn.contextStack2.size = stackSize;
            vn.pop2();
            right.reset(vn);
            return false;
        }
        catch (Exception e) {
            throw new RuntimeException("Undefined behavior");
        }
    }

    private boolean compNodeSetNumerical(Expr left, Expr right, VTDNavHuge vn, int op) {
        int i1 = 0;
        try {
            int i;
            double d = right.evalNumber(vn);
            vn.push2();
            int stackSize = vn.contextStack2.size;
            while ((i = left.evalNodeSet(vn)) != -1) {
                i1 = this.getStringVal(vn, i);
                if (i1 == -1 || !this.compareVNumber2(i1, vn, d, op)) continue;
                left.reset(vn);
                vn.contextStack2.size = stackSize;
                vn.pop2();
                return true;
            }
            vn.contextStack2.size = stackSize;
            vn.pop2();
            left.reset(vn);
            return false;
        }
        catch (Exception e) {
            throw new RuntimeException("Undefined behavior");
        }
    }

    private int getStringVal(VTDNavHuge vn, int i) {
        int t = vn.getTokenType(i);
        if (t == 0) {
            int i1 = vn.getText();
            return i1;
        }
        if (t == 2 || t == 3) {
            return i + 1;
        }
        return i;
    }

    private boolean compareVNumber1(int k, VTDNavHuge vn, double d, int op) throws NavExceptionHuge {
        double d1 = vn.parseDouble(k);
        switch (op) {
            case 7: {
                return d == d1;
            }
            case 8: {
                return d != d1;
            }
            case 10: {
                return d >= d1;
            }
            case 9: {
                return d <= d1;
            }
            case 12: {
                return d > d1;
            }
        }
        return d < d1;
    }

    private boolean compareVString1(int k, VTDNavHuge vn, String s, int op) throws NavExceptionHuge {
        int i = vn.compareTokenString(k, s);
        switch (i) {
            case -1: {
                if (op != 8 && op != 11 && op != 9) break;
                return true;
            }
            case 0: {
                if (op != 7 && op != 9 && op != 10) break;
                return true;
            }
            case 1: {
                if (op != 8 && op != 10 && op != 12) break;
                return true;
            }
        }
        return false;
    }

    private boolean compareVString2(int k, VTDNavHuge vn, String s, int op) throws NavExceptionHuge {
        int i = vn.compareTokenString(k, s);
        switch (i) {
            case -1: {
                if (op != 8 && op != 12 && op != 10) break;
                return true;
            }
            case 0: {
                if (op != 7 && op != 9 && op != 10) break;
                return true;
            }
            case 1: {
                if (op != 8 && op != 9 && op != 11) break;
                return true;
            }
        }
        return false;
    }

    private boolean compareVNumber2(int k, VTDNavHuge vn, double d, int op) throws NavExceptionHuge {
        double d1 = vn.parseDouble(k);
        switch (op) {
            case 7: {
                return d1 == d;
            }
            case 8: {
                return d1 != d;
            }
            case 10: {
                return d1 >= d;
            }
            case 9: {
                return d1 <= d;
            }
            case 12: {
                return d1 > d;
            }
        }
        return d1 < d;
    }

    private boolean compareVV(int k, VTDNavHuge vn, int j, int op) throws NavExceptionHuge {
        int i = vn.compareTokens(k, vn, j);
        switch (i) {
            case 1: {
                if (op != 8 && op != 10 && op != 12) break;
                return true;
            }
            case 0: {
                if (op != 7 && op != 9 && op != 10) break;
                return true;
            }
            case -1: {
                if (op != 8 && op != 11 && op != 9) break;
                return true;
            }
        }
        return false;
    }

    private boolean compNodeSetNodeSet(Expr left, Expr right, VTDNavHuge vn, int op) {
        try {
            int i1;
            int i;
            if (this.fib1 == null) {
                this.fib1 = new FastIntBuffer(7);
            }
            vn.push2();
            int stackSize = vn.contextStack2.size;
            while ((i = left.evalNodeSet(vn)) != -1) {
                i1 = this.getStringVal(vn, i);
                if (i1 == -1) continue;
                this.fib1.append(i1);
            }
            left.reset(vn);
            vn.contextStack2.size = stackSize;
            vn.pop2();
            vn.push2();
            stackSize = vn.contextStack2.size;
            while ((i = right.evalNodeSet(vn)) != -1) {
                i1 = this.getStringVal(vn, i);
                if (i1 == -1) continue;
                int s1 = this.fib1.size();
                for (int k = 0; k < s1; ++k) {
                    boolean b = this.compareVV(this.fib1.intAt(k), vn, i1, op);
                    if (!b) continue;
                    this.fib1.clear();
                    vn.contextStack2.size = stackSize;
                    vn.pop2();
                    right.reset(vn);
                    return true;
                }
            }
            vn.contextStack2.size = stackSize;
            vn.pop2();
            right.reset(vn);
            this.fib1.clear();
            return false;
        }
        catch (Exception e) {
            this.fib1.clear();
            throw new RuntimeException("Undefined behavior");
        }
    }

    @Override
    public int adjust(int n) {
        int j;
        int i = this.left.adjust(n);
        if (i > (j = this.right.adjust(n))) {
            return i;
        }
        return j;
    }
}

