/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.interceptor;

import com.squareup.okhttp.Connection;
import com.squareup.okhttp.Headers;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.Protocol;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.RequestBody;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import com.squareup.okhttp.internal.http.HttpEngine;
import com.volcengine.observability.debugger.LogLevel;
import com.volcengine.observability.debugger.SdkDebugLog;
import com.volcengine.utils.ConstantsUtil;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.concurrent.TimeUnit;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;

public final class HttpLoggingInterceptor
implements Interceptor {
    private static final String HEAD_LOG_ID = "X-Tt-Logid";
    private static final Charset UTF8 = Charset.forName("UTF-8");

    public Response intercept(Interceptor.Chain chain) throws IOException {
        this.logRequestLog(chain);
        Request request = chain.request();
        long startNs = System.nanoTime();
        Response response = chain.proceed(request);
        long tookMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNs);
        this.logResponseLog(response, tookMs);
        return response;
    }

    private void logResponseLog(Response response, long tookMs) throws IOException {
        Headers headers = response.headers();
        if (SdkDebugLog.SDK_CORE_LOGGER.matches(LogLevel.LOG_DEBUG_WITH_REQUEST_ID) || SdkDebugLog.SDK_CORE_LOGGER.isDebugEnabled()) {
            String responseState = response.isSuccessful() ? "successful" : "failed";
            SdkDebugLog.SDK_CORE_LOGGER.debugRequestID("Received " + responseState + " response: " + response.code() + ", RequestId: " + headers.get(HEAD_LOG_ID), new Object[0]);
        }
        boolean logBody = SdkDebugLog.SDK_CORE_LOGGER.matches(LogLevel.LOG_DEBUG_WITH_RESPONSE_BODY);
        if (SdkDebugLog.SDK_CORE_LOGGER.matches(LogLevel.LOG_DEBUG_WITH_RESPONSE)) {
            StringBuilder responseInfo = new StringBuilder();
            ResponseBody responseBody = response.body();
            responseInfo.append(ConstantsUtil.NEW_LINE + "<-- " + HttpLoggingInterceptor.protocol(response.protocol()) + ' ' + response.code() + ' ' + response.message() + " (" + tookMs + "ms, " + responseBody.contentLength() + "-byte body" + ')');
            int count = headers.size();
            for (int i = 0; i < count; ++i) {
                responseInfo.append(ConstantsUtil.NEW_LINE + headers.name(i) + ": " + headers.value(i));
            }
            if (!logBody || !HttpEngine.hasBody((Response)response)) {
                responseInfo.append(ConstantsUtil.NEW_LINE + "<-- END HTTP");
            } else if (this.bodyEncoded(response.headers())) {
                responseInfo.append(ConstantsUtil.NEW_LINE + "<-- END HTTP (encoded body omitted)");
            } else {
                BufferedSource source = responseBody.source();
                source.request(Long.MAX_VALUE);
                Buffer buffer = source.buffer();
                Charset charset = UTF8;
                MediaType contentType = responseBody.contentType();
                if (contentType != null) {
                    charset = contentType.charset(UTF8);
                }
                if (responseBody.contentLength() != 0L) {
                    responseInfo.append(ConstantsUtil.NEW_LINE + "ResponseBody: ");
                    responseInfo.append(buffer.clone().readString(charset));
                }
                responseInfo.append(ConstantsUtil.NEW_LINE + "<-- END HTTP (" + buffer.size() + "-byte body)");
            }
            if (logBody) {
                SdkDebugLog.SDK_CORE_LOGGER.debugResponseBody(responseInfo.toString(), new Object[0]);
            } else {
                SdkDebugLog.SDK_CORE_LOGGER.debugResponse(responseInfo.toString(), new Object[0]);
            }
        }
    }

    private void logRequestLog(Interceptor.Chain chain) throws IOException {
        boolean logBody = SdkDebugLog.SDK_CORE_LOGGER.matches(LogLevel.LOG_DEBUG_WITH_REQUEST_BODY);
        if (SdkDebugLog.SDK_CORE_LOGGER.matches(LogLevel.LOG_DEBUG_WITH_REQUEST)) {
            Request request = chain.request();
            RequestBody requestBody = request.body();
            boolean hasRequestBody = requestBody != null;
            Connection connection = chain.connection();
            Protocol protocol = connection != null ? connection.getProtocol() : Protocol.HTTP_1_1;
            StringBuilder requestLog = new StringBuilder();
            requestLog.append("--> " + request.method() + ' ' + request.httpUrl() + ' ' + HttpLoggingInterceptor.protocol(protocol));
            if (logBody && hasRequestBody) {
                requestLog.append(" (" + requestBody.contentLength() + "-byte body)");
            }
            if (logBody && hasRequestBody) {
                if (requestBody.contentType() != null) {
                    requestLog.append(ConstantsUtil.NEW_LINE + "Content-Type: " + requestBody.contentType());
                }
                if (requestBody.contentLength() != -1L) {
                    requestLog.append(ConstantsUtil.NEW_LINE + "Content-Length: " + requestBody.contentLength());
                }
            }
            Headers headers = request.headers();
            int count = headers.size();
            for (int i = 0; i < count; ++i) {
                String name = headers.name(i);
                if ("Content-Type".equalsIgnoreCase(name) || "Content-Length".equalsIgnoreCase(name)) continue;
                requestLog.append(ConstantsUtil.NEW_LINE + ": " + headers.value(i));
            }
            if (!hasRequestBody || !logBody) {
                requestLog.append(ConstantsUtil.NEW_LINE + "--> END " + request.method());
            } else if (this.bodyEncoded(request.headers())) {
                requestLog.append(ConstantsUtil.NEW_LINE + "--> END " + request.method() + " (encoded body omitted)");
            } else {
                Buffer buffer = new Buffer();
                requestBody.writeTo((BufferedSink)buffer);
                Charset charset = UTF8;
                MediaType contentType = requestBody.contentType();
                if (contentType != null) {
                    contentType.charset(UTF8);
                }
                requestLog.append("");
                requestLog.append(buffer.readString(charset));
                requestLog.append("--> END " + request.method() + " (" + requestBody.contentLength() + "-byte body)");
            }
            if (logBody && hasRequestBody) {
                SdkDebugLog.SDK_CORE_LOGGER.debugRequestBody(requestLog.toString(), new Object[0]);
            } else {
                SdkDebugLog.SDK_CORE_LOGGER.debugRequest(requestLog.toString(), new Object[0]);
            }
        }
    }

    private boolean bodyEncoded(Headers headers) {
        String contentEncoding = headers.get("Content-Encoding");
        return contentEncoding != null && !contentEncoding.equalsIgnoreCase("identity");
    }

    private static String protocol(Protocol protocol) {
        return protocol == Protocol.HTTP_1_0 ? "HTTP/1.0" : "HTTP/1.1";
    }
}

