/*
 * Decompiled with CFR 0.152.
 */
package com.vackosar.gitflowincrementalbuild.control;

public enum Property {
    enabled("true"),
    repositorySshKey(""),
    referenceBranch("refs/remotes/origin/develop"),
    baseBranch("HEAD"),
    uncommited("true"),
    skipTestsForNotImpactedModules("false"),
    buildAll("false"),
    compareToMergeBase("true"),
    fetchBaseBranch("false"),
    fetchReferenceBranch("false"),
    excludePathRegex("(?!x)x"),
    failOnMissingGitDir("true"),
    failOnError("true");

    public static final String PREFIX = "gib.";
    public final String defaultValue;

    private Property(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    private String exemplify() {
        return "<" + this.fullName() + ">" + (this.defaultValue == null ? "" : this.defaultValue) + "</" + this.fullName() + ">";
    }

    public String fullName() {
        return PREFIX + this.name();
    }

    public String getValue() {
        return System.getProperty(this.fullName(), this.defaultValue);
    }

    public void setValue(String value) {
        if (value == null) {
            System.clearProperty(this.fullName());
        } else {
            System.setProperty(this.fullName(), value);
        }
    }

    public static String exemplifyAll() {
        StringBuilder builder = new StringBuilder();
        builder.append("<properties>\n");
        for (Property value : Property.values()) {
            builder.append("\t").append(value.exemplify()).append("\n");
        }
        builder.append("</properties>\n");
        return builder.toString();
    }

    private static class Constants {
        private static final String NEVER_MATCH_REGEX = "(?!x)x";

        private Constants() {
        }
    }
}

