/*
 * Decompiled with CFR 0.152.
 */
package com.vackosar.gitflowincrementalbuild.boundary;

import com.vackosar.gitflowincrementalbuild.control.Property;
import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.maven.MavenExecutionException;
import org.apache.maven.execution.MavenSession;

@Singleton
public class Configuration {
    private static final List<String> alsoMakeBehaviours = Arrays.asList("make-upstream", "make-both");
    public final boolean enabled;
    public final Optional<Path> key;
    public final String referenceBranch;
    public String baseBranch;
    public final boolean uncommited;
    public final boolean makeUpstream;
    public final boolean skipTestsForNotImpactedModules;
    public final boolean buildAll;
    public final boolean compareToMergeBase;
    public final boolean fetchBaseBranch;
    public final boolean fetchReferenceBranch;
    public final Predicate<String> excludePathRegex;
    public final boolean failOnMissingGitDir;

    @Inject
    public Configuration(MavenSession session) throws IOException {
        try {
            this.checkProperties();
            this.enabled = Boolean.valueOf(Property.enabled.getValue());
            this.key = this.parseKey(session);
            this.referenceBranch = Property.referenceBranch.getValue();
            this.baseBranch = Property.baseBranch.getValue();
            this.uncommited = Boolean.valueOf(Property.uncommited.getValue());
            this.makeUpstream = alsoMakeBehaviours.contains(session.getRequest().getMakeBehavior());
            this.skipTestsForNotImpactedModules = Boolean.valueOf(Property.skipTestsForNotImpactedModules.getValue());
            this.buildAll = Boolean.valueOf(Property.buildAll.getValue());
            this.compareToMergeBase = Boolean.valueOf(Property.compareToMergeBase.getValue());
            this.fetchReferenceBranch = Boolean.valueOf(Property.fetchReferenceBranch.getValue());
            this.fetchBaseBranch = Boolean.valueOf(Property.fetchBaseBranch.getValue());
            this.excludePathRegex = Pattern.compile(Property.excludePathRegex.getValue()).asPredicate();
            this.failOnMissingGitDir = Boolean.valueOf(Property.failOnMissingGitDir.getValue());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Optional<Path> parseKey(MavenSession session) throws IOException {
        Path pomDir = session.getCurrentProject().getBasedir().toPath();
        String keyOptionValue = Property.repositorySshKey.getValue();
        if (keyOptionValue != null && !keyOptionValue.isEmpty()) {
            return Optional.of(pomDir.resolve(keyOptionValue).toAbsolutePath().toRealPath(new LinkOption[0]).normalize());
        }
        return Optional.empty();
    }

    private void checkProperties() throws MavenExecutionException {
        try {
            System.getProperties().entrySet().stream().map(Map.Entry::getKey).filter(o -> o instanceof String).map(o -> (String)o).filter(s -> s.startsWith("gib.")).map(s -> s.replaceFirst("gib.", "")).forEach(Property::valueOf);
        }
        catch (IllegalArgumentException e) {
            throw new MavenExecutionException("Invalid invalid GIB property found. Allowed properties: \n" + Property.exemplifyAll(), (Throwable)e);
        }
    }
}

