/*
 * Decompiled with CFR 0.152.
 */
package test.java;

import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import main.java.com.upyun.ResumeUploader;
import main.java.com.upyun.UpException;
import org.junit.Assert;
import org.junit.Test;

public class ResumeTest {
    private static final String BUCKET_NAME = "formtest";
    private static final String OPERATOR_NAME = "one";
    private static final String OPERATOR_PWD = "qwertyuiop";
    private static final String SAMPLE_PIC_FILE = System.getProperty("user.dir") + "/test.MOV";
    private static final String UPLOAD_PATH = "/test.MOV";

    @Test
    public void testResumeUpload() throws InterruptedException, IOException, UpException {
        final ResumeUploader resume = new ResumeUploader(BUCKET_NAME, OPERATOR_NAME, OPERATOR_PWD);
        final CountDownLatch latch = new CountDownLatch(1);
        resume.setOnProgressListener(new ResumeUploader.OnProgressListener(){

            public void onProgress(int index, int total) {
                Assert.assertTrue((index <= total ? 1 : 0) != 0);
                System.out.println(index + "::" + total + "::" + index * 100 / total + "%");
            }
        });
        resume.setCheckMD5(true);
        new Thread(){

            public void run() {
                super.run();
                try {
                    Assert.assertFalse((boolean)resume.upload(SAMPLE_PIC_FILE, ResumeTest.UPLOAD_PATH, null));
                    latch.countDown();
                }
                catch (Exception e) {
                    System.out.println(e);
                }
            }
        }.start();
        Thread.sleep(2000L);
        resume.interrupt(new ResumeUploader.OnInterruptListener(){

            public void OnInterrupt(boolean interrupted) {
                System.out.println("interrupted:" + interrupted);
                if (interrupted) {
                    try {
                        Assert.assertTrue((boolean)resume.upload(SAMPLE_PIC_FILE, ResumeTest.UPLOAD_PATH, null));
                    }
                    catch (IOException e) {
                        Assert.fail();
                    }
                    catch (UpException e) {
                        Assert.fail();
                    }
                }
            }
        });
        latch.await();
    }
}

