/*
 * Decompiled with CFR 0.152.
 */
package test.java;

import java.io.IOException;
import java.util.HashMap;
import main.java.com.upyun.MediaHandler;
import main.java.com.upyun.Result;
import main.java.com.upyun.UpException;
import org.json.JSONArray;
import org.json.JSONObject;
import org.junit.Assert;
import org.junit.Test;

public class MediaHandlerTest {
    private static final String BUCKET_NAME = "formtest";
    private static final String OPERATOR_NAME = "one";
    private static final String OPERATOR_PWD = "qwertyuiop";

    @Test
    public void testMediaProcess() {
        MediaHandler handler = new MediaHandler(BUCKET_NAME, OPERATOR_NAME, OPERATOR_PWD);
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        paramsMap.put("bucket_name", BUCKET_NAME);
        paramsMap.put("notify_url", "http://httpbin.org/post");
        paramsMap.put("accept", "json");
        paramsMap.put("source", "/test.mp4");
        JSONArray array = new JSONArray();
        JSONObject json = new JSONObject();
        json.put("type", (Object)"video");
        json.put("avopts", (Object)"/s/240p(4:3)/as/1/r/30");
        json.put("return_info", (Object)"true");
        json.put("save_as", (Object)"testProcess.mp4");
        JSONObject json2 = new JSONObject();
        json2.put("type", (Object)"video");
        json2.put("avopts", (Object)"/s/240p(4:3)/as/1/r/30");
        json2.put("return_info", (Object)"true");
        json2.put("save_as", (Object)"testProcess2.mp4");
        array.put((Object)json2);
        array.put((Object)json);
        paramsMap.put("tasks", array);
        Result result = null;
        try {
            result = handler.process(paramsMap);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (UpException e) {
            e.printStackTrace();
        }
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.isSucceed());
        Assert.assertNotNull((Object)result.getMsg());
        String[] ids = handler.getTaskId(result.getMsg());
        Assert.assertNotNull((Object)ids);
    }

    @Test
    public void testMediaStatus() {
        String[] ids = new String[]{"02774703e7f5cc855681a7c42d819722", "921110d3843e92ac7932ff216e5ea348"};
        MediaHandler handle = new MediaHandler(BUCKET_NAME, OPERATOR_NAME, OPERATOR_PWD);
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        paramsMap.put("bucket_name", BUCKET_NAME);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < ids.length; ++i) {
            sb.append(ids[i] + ",");
        }
        String task_ids = sb.toString().substring(0, sb.length() - 1);
        paramsMap.put("task_ids", task_ids);
        Result result = null;
        try {
            result = handle.getStatus(paramsMap);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (UpException e) {
            e.printStackTrace();
        }
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.isSucceed());
        Assert.assertNotNull((Object)result.getMsg());
    }

    @Test
    public void testMediaResult() {
        String[] ids = new String[]{"02774703e7f5cc855681a7c42d819722", "921110d3843e92ac7932ff216e5ea348"};
        MediaHandler handle = new MediaHandler(BUCKET_NAME, OPERATOR_NAME, OPERATOR_PWD);
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        paramsMap.put("bucket_name", BUCKET_NAME);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < ids.length; ++i) {
            sb.append(ids[i] + ",");
        }
        String task_ids = sb.toString().substring(0, sb.length() - 1);
        paramsMap.put("task_ids", task_ids);
        Result result = null;
        try {
            result = handle.getStatus(paramsMap);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (UpException e) {
            e.printStackTrace();
        }
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.isSucceed());
        Assert.assertNotNull((Object)result.getMsg());
    }
}

