/*
 * Decompiled with CFR 0.152.
 */
package main.java.demo;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import main.java.com.upyun.MediaHandler;
import main.java.com.upyun.Result;
import main.java.com.upyun.UpException;
import org.json.JSONArray;
import org.json.JSONObject;

public class MediaHandlerDemo {
    private static final String BUCKET_NAME = "\u7a7a\u95f4\u540d\u79f0";
    private static final String OPERATOR_NAME = "\u64cd\u4f5c\u5458\u540d\u79f0";
    private static final String OPERATOR_PWD = "\u64cd\u4f5c\u5458\u5bc6\u7801";

    public static void main(String[] args) {
        String[] ids = MediaHandlerDemo.testMediaProcess();
        if (ids != null) {
            MediaHandlerDemo.testMediaStatus(ids);
            MediaHandlerDemo.testMediaResult(ids);
        }
    }

    private static String[] testMediaProcess() {
        MediaHandler handler = new MediaHandler(BUCKET_NAME, OPERATOR_NAME, OPERATOR_PWD);
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        paramsMap.put("bucket_name", BUCKET_NAME);
        paramsMap.put("notify_url", "http://httpbin.org/post");
        paramsMap.put("accept", "json");
        paramsMap.put("source", "/test.mp4");
        JSONArray array = new JSONArray();
        JSONObject json = new JSONObject();
        json.put("type", (Object)"video");
        json.put("avopts", (Object)"/s/240p(4:3)/as/1/r/30");
        json.put("return_info", (Object)"true");
        json.put("save_as", (Object)"testProcess.mp4");
        JSONObject json2 = new JSONObject();
        json2.put("type", (Object)"video");
        json2.put("avopts", (Object)"/s/240p(4:3)/as/1/r/30");
        json2.put("return_info", (Object)"true");
        json2.put("save_as", (Object)"testProcess2.mp4");
        array.put((Object)json2);
        array.put((Object)json);
        paramsMap.put("tasks", array);
        try {
            Result result = handler.process(paramsMap);
            System.out.println(result);
            if (result.isSucceed()) {
                Object[] ids = handler.getTaskId(result.getMsg());
                System.out.println(Arrays.toString(ids));
                return ids;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (UpException e) {
            e.printStackTrace();
        }
        return null;
    }

    private static void testMediaStatus(String[] ids) {
        MediaHandler handle = new MediaHandler(BUCKET_NAME, OPERATOR_NAME, OPERATOR_PWD);
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        paramsMap.put("bucket_name", BUCKET_NAME);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < ids.length; ++i) {
            sb.append(ids[i] + ",");
        }
        String task_ids = sb.toString().substring(0, sb.length() - 1);
        paramsMap.put("task_ids", task_ids);
        try {
            Result result = handle.getStatus(paramsMap);
            System.out.println("status:" + result);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (UpException e) {
            e.printStackTrace();
        }
    }

    private static void testMediaResult(String[] ids) {
        MediaHandler handle = new MediaHandler(BUCKET_NAME, OPERATOR_NAME, OPERATOR_PWD);
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        paramsMap.put("bucket_name", BUCKET_NAME);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < ids.length; ++i) {
            sb.append(ids[i] + ",");
        }
        String task_ids = sb.toString().substring(0, sb.length() - 1);
        paramsMap.put("task_ids", task_ids);
        try {
            Result result = handle.getResult(paramsMap);
            System.out.println("result:" + result);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (UpException e) {
            e.printStackTrace();
        }
    }
}

