/*
 * Decompiled with CFR 0.152.
 */
package main.java.demo;

import java.io.File;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.util.HashMap;
import main.java.com.upyun.FormUploader;
import main.java.com.upyun.Result;
import org.json.JSONArray;
import org.json.JSONObject;

public class FormUploadDemo {
    private static final String BUCKET_NAME = "formtest";
    private static final String OPERATOR_NAME = "one";
    private static final String OPERATOR_PWD = "qwertyuiop";
    private static final String SAMPLE_PIC_FILE = System.getProperty("user.dir") + "/sample.jpeg";
    private static File file = new File(SAMPLE_PIC_FILE);
    private static String savePath = "/uploads/{year}{mon}{day}/{random32}{.suffix}";

    public static void main(String[] args) throws NoSuchAlgorithmException, SignatureException, InvalidKeyException {
        FormUploadDemo.testWriteFile();
        FormUploadDemo.testWatermark();
        FormUploadDemo.testSync();
        FormUploadDemo.testAsync();
    }

    private static void testWriteFile() throws NoSuchAlgorithmException, SignatureException, InvalidKeyException {
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        paramsMap.put("save-key", savePath);
        FormUploader uploader = new FormUploader(BUCKET_NAME, OPERATOR_NAME, OPERATOR_PWD);
        Result result = uploader.upload(paramsMap, file);
        System.out.println(result);
        System.out.println(uploader.upload(paramsMap, "test1".getBytes()));
    }

    private static void testWatermark() throws NoSuchAlgorithmException, SignatureException, InvalidKeyException {
        FormUploader uploader = new FormUploader(BUCKET_NAME, OPERATOR_NAME, OPERATOR_PWD);
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        paramsMap.put("save-key", savePath);
        paramsMap.put("x-gmkerl-thumb", "/watermark/text/5L2g5aW977yB");
        System.out.println(uploader.upload(paramsMap, file));
    }

    private static void testSync() throws NoSuchAlgorithmException, SignatureException, InvalidKeyException {
        FormUploader uploader = new FormUploader(BUCKET_NAME, OPERATOR_NAME, OPERATOR_PWD);
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        paramsMap.put("save-key", savePath);
        paramsMap.put("x-gmkerl-thumb", "/fw/300/unsharp/true/quality/80/format/png");
        System.out.println(uploader.upload(paramsMap, file));
    }

    private static void testAsync() throws NoSuchAlgorithmException, SignatureException, InvalidKeyException {
        FormUploader uploader = new FormUploader(BUCKET_NAME, OPERATOR_NAME, OPERATOR_PWD);
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        paramsMap.put("save-key", savePath);
        JSONArray array = new JSONArray();
        JSONObject json = new JSONObject();
        json.put("name", (Object)"thumb");
        json.put("x-gmkerl-thumb", (Object)"/fw/300/unsharp/true/quality/80/format/png");
        json.put("save_as", (Object)"/path/to/fw_100.jpg");
        json.put("notify_url", (Object)"http://httpbin.org/post");
        array.put((Object)json);
        paramsMap.put("apps", array);
        System.out.println(uploader.upload(paramsMap, file));
    }
}

