/*
 * Decompiled with CFR 0.152.
 */
package main.java.com.upyun;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import main.java.com.upyun.UpException;
import main.java.com.upyun.UpYunUtils;
import okhttp3.Call;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResumeUploader {
    private static final String AUTHORIZATION = "Authorization";
    private static final int BLOCK_SIZE = 0x100000;
    private final String DATE = "Date";
    private static final String CONTENT_MD5 = "Content-MD5";
    private static final String CONTENT_TYPE = "CContent-Type";
    private static final String CONTENT_SECRET = "Content-Secret";
    private static final String X_Upyun_Meta_X = "X-Upyun-Meta-X";
    private static final String X_UPYUN_MULTI_STAGE = "X-Upyun-Multi-Stage";
    private static final String X_UPYUN_MULTI_TYPE = "X-Upyun-Multi-Type";
    private static final String X_UPYUN_MULTI_LENGTH = "X-Upyun-Multi-Length";
    private static final String X_UPYUN_META_X = "X-Upyun-Meta-X";
    private static final String X_UPYUN_MULTI_UUID = "X-Upyun-Multi-UUID";
    private static final String X_UPYUN_PART_ID = "X-Upyun-Part-ID";
    private static final String X_UPYUN_NEXT_PART_ID = "X-Upyun-Next-Part-ID";
    private static final String HOST = "http://v0.api.upyun.com";
    private String uuid;
    private String uploadPath;
    private OkHttpClient mClient;
    private File mFile;
    private int nextPartIndex;
    private RandomAccessFile randomAccessFile;
    private boolean checkMD5;
    protected String bucketName = null;
    protected String userName = null;
    protected String password = null;
    private int timeout = 20;
    private String url;
    private boolean interrupt;
    private Call currentCall;
    private OnProgressListener onProgressListener;
    private OnInterruptListener onInterruptListener;
    private int totalBlock;
    private boolean executed;

    public boolean resume() throws IOException, UpException {
        if (this.uuid == null) {
            throw new UpException("uuid is null, please restart!");
        }
        this.interrupt = false;
        return this.processUpload();
    }

    public boolean resume(String uuid, int newxtPartIndex) throws IOException, UpException {
        this.uuid = uuid;
        this.nextPartIndex = newxtPartIndex;
        if (uuid == null) {
            throw new UpException("uuid is null, please restart!");
        }
        this.interrupt = false;
        return this.processUpload();
    }

    public ResumeUploader(String bucketName, String userName, String password) {
        this.bucketName = bucketName;
        this.userName = userName;
        this.password = UpYunUtils.md5(password);
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void interrupt(OnInterruptListener listener) {
        this.onInterruptListener = listener;
        this.interrupt = true;
    }

    public boolean upload(String filePath, String uploadPath, Map<String, String> params) throws IOException, UpException {
        this.interrupt = false;
        this.mFile = new File(filePath);
        this.totalBlock = (int)Math.ceil((double)this.mFile.length() / 1048576.0 + 2.0);
        this.randomAccessFile = new RandomAccessFile(this.mFile, "r");
        this.uploadPath = uploadPath;
        this.url = "http://v0.api.upyun.com/" + this.bucketName + uploadPath;
        this.mClient = new OkHttpClient.Builder().connectTimeout((long)this.timeout, TimeUnit.SECONDS).readTimeout((long)this.timeout, TimeUnit.SECONDS).writeTimeout((long)this.timeout, TimeUnit.SECONDS).build();
        return this.startUpload(params);
    }

    public String getUuid() {
        return this.uuid;
    }

    public int getNextPartIndex() {
        return this.nextPartIndex;
    }

    public void setCheckMD5(boolean checkMD5) {
        this.checkMD5 = checkMD5;
    }

    public void setOnProgressListener(OnProgressListener onProgressListener) {
        this.onProgressListener = onProgressListener;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public void setNextPartIndex(int nextPartIndex) {
        this.nextPartIndex = nextPartIndex;
    }

    private boolean startUpload(Map<String, String> params) throws IOException, UpException {
        if (this.uuid != null) {
            return this.processUpload();
        }
        RequestBody requestBody = RequestBody.create(null, (String)"");
        String date = this.getGMTDate();
        String md5 = null;
        if (this.checkMD5) {
            md5 = UpYunUtils.md5("");
        }
        String sign = UpYunUtils.sign("PUT", date, this.uploadPath, this.bucketName, this.userName, this.password, md5);
        Request.Builder builder = new Request.Builder().url(this.url).header("Date", date).header(AUTHORIZATION, sign.trim()).header(X_UPYUN_MULTI_STAGE, "initiate").header(X_UPYUN_MULTI_TYPE, "application/octet-stream").header(X_UPYUN_MULTI_LENGTH, this.mFile.length() + "").header("User-Agent", "upyun-java-sdk/3.11").put(requestBody);
        if (params != null) {
            for (Map.Entry<String, String> entry : params.entrySet()) {
                builder.header(entry.getKey(), entry.getValue());
            }
        }
        if (md5 != null) {
            builder.header(CONTENT_MD5, md5);
        }
        this.callRequest(builder.build());
        if (this.onProgressListener != null) {
            this.onProgressListener.onProgress(1, this.totalBlock);
        }
        return this.processUpload();
    }

    private boolean processUpload() throws IOException, UpException {
        byte[] data = new byte[]{};
        while (this.nextPartIndex >= 0) {
            if (this.interrupt && this.onInterruptListener != null) {
                this.onInterruptListener.OnInterrupt(true);
                this.onInterruptListener = null;
                return false;
            }
            data = this.readBlockByIndex(this.nextPartIndex);
            RequestBody requestBody = RequestBody.create(null, (byte[])data);
            String date = this.getGMTDate();
            String md5 = null;
            if (this.checkMD5) {
                md5 = UpYunUtils.md5(data);
            }
            String sign = UpYunUtils.sign("PUT", date, this.uploadPath, this.bucketName, this.userName, this.password, md5);
            Request.Builder builder = new Request.Builder().url(this.url).header("Date", date).header(AUTHORIZATION, sign.trim()).header(X_UPYUN_MULTI_STAGE, "upload").header(X_UPYUN_MULTI_UUID, this.uuid).header(X_UPYUN_PART_ID, this.nextPartIndex + "").header("User-Agent", "upyun-java-sdk/3.11").put(requestBody);
            if (md5 != null) {
                builder.header(CONTENT_MD5, md5);
            }
            if (this.onProgressListener != null) {
                this.onProgressListener.onProgress(this.nextPartIndex + 2, this.totalBlock);
            }
            this.callRequest(builder.build());
        }
        return this.completeUpload();
    }

    private boolean completeUpload() throws IOException, UpException {
        if (this.interrupt && this.onInterruptListener != null) {
            this.onInterruptListener.OnInterrupt(true);
            this.onInterruptListener = null;
            return false;
        }
        RequestBody requestBody = RequestBody.create(null, (String)"");
        String date = this.getGMTDate();
        String md5 = null;
        if (this.checkMD5) {
            md5 = UpYunUtils.md5("");
        }
        String sign = UpYunUtils.sign("PUT", date, this.uploadPath, this.bucketName, this.userName, this.password, md5);
        Request.Builder builder = new Request.Builder().url(this.url).header("Date", date).header(AUTHORIZATION, sign.trim()).header(X_UPYUN_MULTI_STAGE, "complete").header(X_UPYUN_MULTI_UUID, this.uuid).header("User-Agent", "upyun-java-sdk/3.11").put(requestBody);
        if (md5 != null) {
            builder.header(CONTENT_MD5, md5);
        }
        this.callRequest(builder.build());
        if (this.onProgressListener != null) {
            this.onProgressListener.onProgress(this.totalBlock, this.totalBlock);
        }
        this.uuid = null;
        return true;
    }

    private void callRequest(Request request) throws IOException, UpException {
        this.currentCall = this.mClient.newCall(request);
        Response response = this.currentCall.execute();
        if (!response.isSuccessful()) {
            this.uuid = null;
            throw new UpException(response.body().string());
        }
        this.uuid = response.header(X_UPYUN_MULTI_UUID, "");
        this.nextPartIndex = Integer.parseInt(response.header(X_UPYUN_NEXT_PART_ID, "-2"));
    }

    private String getGMTDate() {
        SimpleDateFormat formater = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss 'GMT'", Locale.US);
        formater.setTimeZone(TimeZone.getTimeZone("GMT"));
        return formater.format(new Date());
    }

    private byte[] readBlockByIndex(int index) throws IOException {
        byte[] block = new byte[0x100000];
        int readedSize = 0;
        int offset = index * 0x100000;
        this.randomAccessFile.seek(offset);
        readedSize = this.randomAccessFile.read(block, 0, 0x100000);
        if (readedSize < 0x100000) {
            byte[] notFullBlock = new byte[readedSize];
            System.arraycopy(block, 0, notFullBlock, 0, readedSize);
            return notFullBlock;
        }
        return block;
    }

    public static interface OnInterruptListener {
        public void OnInterrupt(boolean var1);
    }

    public static interface OnProgressListener {
        public void onProgress(int var1, int var2);
    }
}

