/*
 * Decompiled with CFR 0.152.
 */
package main.java.com.upyun;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.util.Map;
import main.java.com.upyun.Base64Coder;
import main.java.com.upyun.Result;
import main.java.com.upyun.UpYunUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormUploader {
    private int timeout = 30000;
    private int expiration = 1800;
    private String apiDomain = "http://v0.api.upyun.com";
    protected String bucketName = null;
    protected String userName = null;
    protected String password = null;

    public int getTimeout() {
        return this.timeout;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public int getExpiration() {
        return this.expiration;
    }

    public void setExpiration(int expiration) {
        this.expiration = expiration;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public FormUploader(String bucketName, String userName, String password) {
        this.bucketName = bucketName;
        this.userName = userName;
        this.password = UpYunUtils.md5(password);
    }

    public Result upload(Map<String, Object> params, File file) throws NoSuchAlgorithmException, SignatureException, InvalidKeyException {
        return this.upload(params, file, null);
    }

    public Result upload(Map<String, Object> params, byte[] datas) throws NoSuchAlgorithmException, SignatureException, InvalidKeyException {
        return this.upload(params, null, datas);
    }

    private Result upload(Map<String, Object> params, File file, byte[] datas) throws NoSuchAlgorithmException, SignatureException, InvalidKeyException {
        Result result;
        String raw;
        byte[] hmac;
        if (params.get("bucket") == null) {
            params.put("bucket", this.bucketName);
        }
        if (params.get("expiration") == null) {
            params.put("expiration", System.currentTimeMillis() / 1000L + (long)this.expiration);
        }
        String policy = UpYunUtils.getPolicy(params);
        String signature = null;
        String date = (String)params.get("date");
        String contentMd5 = (String)params.get("content-md5");
        StringBuilder sb = new StringBuilder();
        String sp = "&";
        sb.append("POST");
        sb.append(sp);
        sb.append("/" + this.bucketName);
        if (date != null) {
            sb.append(sp);
            sb.append(date);
        }
        sb.append(sp);
        sb.append(policy);
        if (contentMd5 != null) {
            sb.append(sp);
            sb.append(contentMd5);
        }
        if ((hmac = UpYunUtils.calculateRFC2104HMACRaw(this.password, raw = sb.toString().trim())) != null) {
            signature = Base64Coder.encodeLines(hmac);
        }
        System.out.println("sign" + signature);
        URL url = null;
        try {
            url = new URL(this.getApiDomain() + "/" + this.bucketName);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("\u57df\u540d\u9519\u8bef\u683c\u5f0f\u9519\u8bef");
        }
        try {
            result = this.postData(file, datas, url, policy, signature.trim());
        }
        catch (IOException e) {
            result = new Result();
            result.setSucceed(false);
            result.setMsg(e.toString());
        }
        return result;
    }

    private Result postData(File file, byte[] datas, URL url, String policy, String signature) throws IOException {
        String BOUNDARY = "---------------------------12121upyun";
        FileInputStream is = null;
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setConnectTimeout(this.timeout);
        conn.setRequestMethod("POST");
        conn.setUseCaches(false);
        conn.setDoOutput(true);
        conn.setRequestProperty("Connection", "Keep-Alive");
        conn.setRequestProperty("User-Agent", "upyun-java-sdk/3.11");
        conn.setRequestProperty("x-upyun-api-version", "2");
        conn.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + BOUNDARY);
        conn.setChunkedStreamingMode(0);
        conn.connect();
        OutputStream os = conn.getOutputStream();
        os.write(this.getBoundaryStr("policy", BOUNDARY, policy).getBytes());
        os.write(this.getBoundaryStr("authorization", BOUNDARY, "UPYUN " + this.userName + ":" + signature).getBytes());
        String fileName = file != null ? file.getName() : "null";
        os.write(this.getBoundaryFileStr("file", BOUNDARY, fileName).getBytes());
        byte[] tempData = new byte[4096];
        int temp = 0;
        if (file != null) {
            is = new FileInputStream(file);
            while ((temp = ((InputStream)is).read(tempData)) != -1) {
                os.write(tempData, 0, temp);
            }
        } else if (datas != null) {
            os.write(datas);
        }
        os.write("\r\n".getBytes());
        os.write(this.paramsEnd(BOUNDARY).getBytes());
        Result result = this.getResult(conn);
        if (os != null) {
            os.close();
        }
        if (is != null) {
            ((InputStream)is).close();
        }
        if (conn != null) {
            conn.disconnect();
        }
        return result;
    }

    private String getBoundaryStr(String key, String BOUNDARY, String value) {
        StringBuffer strBuf = new StringBuffer();
        strBuf.append("\r\n").append("--").append(BOUNDARY).append("\r\n");
        strBuf.append("Content-Disposition: form-data; name=\"" + key + "\"\r\n\r\n");
        strBuf.append(value);
        return strBuf.toString();
    }

    private String getBoundaryFileStr(String key, String BOUNDARY, String filename) {
        StringBuffer strBuf = new StringBuffer();
        strBuf.append("\r\n").append("--").append(BOUNDARY).append("\r\n");
        strBuf.append("Content-Disposition: form-data; name=\"file\"; filename=\"" + filename + "\"\r\n\r\n");
        return strBuf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Result getResult(HttpURLConnection conn) throws IOException {
        Result result = new Result();
        StringBuilder text = new StringBuilder();
        InputStream is = null;
        InputStreamReader sr = null;
        BufferedReader br = null;
        int code = conn.getResponseCode();
        result.setCode(code);
        try {
            is = conn.getInputStream();
            sr = new InputStreamReader(is);
            br = new BufferedReader(sr);
            char[] chars = new char[4096];
            int length = 0;
            while ((length = br.read(chars)) != -1) {
                text.append(chars, 0, length);
            }
        }
        finally {
            if (br != null) {
                br.close();
                br = null;
            }
            if (sr != null) {
                sr.close();
                sr = null;
            }
            if (is != null) {
                is.close();
                is = null;
            }
        }
        if (code == 200) {
            result.setSucceed(true);
        } else {
            result.setSucceed(false);
        }
        result.setMsg(text.toString());
        return result;
    }

    private String paramsEnd(String boundary) {
        return "--" + boundary + "--\r\n";
    }

    public void setApiDomain(String domain) {
        this.apiDomain = domain;
    }

    public String getApiDomain() {
        return this.apiDomain;
    }
}

