/*
 * Decompiled with CFR 0.152.
 */
package com.uifuture.superstarter.boot;

import com.uifuture.supercore.SuperJavaDoc;
import com.uifuture.supercore.framework.AbstractFramework;
import com.uifuture.supercore.model.ApiDoc;
import com.uifuture.supercore.utils.JsonUtils;
import com.uifuture.superspring.framework.SpringWebFramework;
import com.uifuture.superstarter.boot.DocProperties;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@RequestMapping(value={"superJavaDoc"})
public class DocController {
    private static final Logger LOGGER = LoggerFactory.getLogger(DocController.class);
    private static ApiDoc apiDoc;
    @Autowired
    private DocProperties docProperties;

    @PostConstruct
    public void init() {
        if (!this.docProperties.isEnable()) {
            return;
        }
        String path = this.docProperties.getSourcePath();
        if (StringUtils.isBlank((CharSequence)path)) {
            path = ".";
        }
        List<String> paths = Arrays.asList(path.split(","));
        LOGGER.debug("starting SuperJavaDoc, source path:{}", paths);
        try {
            SuperJavaDoc superJavaDoc = new SuperJavaDoc(paths, (AbstractFramework)new SpringWebFramework());
            Thread thread = new Thread(() -> {
                try {
                    apiDoc = superJavaDoc.resolve();
                    HashMap<String, String> properties = new HashMap<String, String>(4);
                    properties.put("version", this.docProperties.getVersion());
                    properties.put("title", this.docProperties.getTitle());
                    apiDoc.setProperties(properties);
                    LOGGER.info("start up SuperJavaDoc");
                }
                catch (Exception e) {
                    LOGGER.error("start up SuperJavaDoc error", (Throwable)e);
                }
            });
            thread.start();
        }
        catch (Exception e) {
            LOGGER.error("start up SuperJavaDoc error", (Throwable)e);
        }
    }

    @GetMapping
    public String index() {
        return "redirect:index.html";
    }

    @ResponseBody
    @RequestMapping(value={"apis"})
    public Object apis() {
        return JsonUtils.toJson((Object)apiDoc);
    }

    @GetMapping(value={"rebuild"})
    public String rebuild() {
        this.init();
        return "redirect:index.html";
    }
}

