/*
 * Decompiled with CFR 0.152.
 */
package com.uifuture.superspring.framework;

import com.uifuture.supercore.framework.AbstractFramework;
import com.uifuture.supercore.model.ApiAction;
import com.uifuture.supercore.model.ApiModule;
import com.uifuture.supercore.model.ObjectInfo;
import com.uifuture.supercore.tag.AbstractDocTag;
import com.uifuture.supercore.tag.impl.ParamTagImpl;
import com.uifuture.supercore.tag.impl.RespTagImpl;
import com.uifuture.supercore.tag.impl.SeeTagImpl;
import com.uifuture.superspring.framework.ParamInfo;
import com.uifuture.superspring.framework.SpringApiAction;
import com.uifuture.superspring.framework.SpringApiModule;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

public class SpringWebFramework
extends AbstractFramework {
    public boolean support(Class<?> classz) {
        return classz.getAnnotation(Controller.class) != null || classz.getAnnotation(RestController.class) != null;
    }

    public List<ApiModule> extend(List<ApiModule> apiModules) {
        if (apiModules == null) {
            return new ArrayList<ApiModule>(0);
        }
        ArrayList<ApiModule> list = new ArrayList<ApiModule>(apiModules.size());
        for (ApiModule apiModule : apiModules) {
            SpringApiModule sam = new SpringApiModule();
            sam.setComment(apiModule.getComment());
            sam.setType(apiModule.getType());
            boolean isjson = this.isJson(apiModule.getType());
            sam.setJson(isjson);
            RequestMapping classRequestMappingAnno = apiModule.getType().getAnnotation(RequestMapping.class);
            if (classRequestMappingAnno != null) {
                String[] urls = classRequestMappingAnno.value();
                this.addSprit(urls);
                sam.setUris(this.getUris(urls));
                sam.setMethods(this.getMethods(classRequestMappingAnno.method()));
            } else {
                sam.setUris(new ArrayList<String>(0));
                sam.setMethods(new ArrayList<String>(0));
            }
            for (ApiAction apiAction : apiModule.getApiActions()) {
                SpringApiAction saa = this.buildSpringApiAction(apiAction, isjson);
                if (saa == null) continue;
                sam.getApiActions().add(saa);
            }
            list.add(sam);
        }
        return list;
    }

    private void addSprit(String[] urls) {
        for (int i = 0; i < urls.length; ++i) {
            if (urls[i].length() > 0) {
                if (urls[i].charAt(0) == '/') continue;
                urls[i] = "/" + urls[i];
                continue;
            }
            urls[i] = "/";
        }
    }

    private SpringApiAction buildSpringApiAction(ApiAction apiAction, boolean isjson) {
        SpringApiAction saa = new SpringApiAction();
        saa.setName(apiAction.getName());
        saa.setComment(apiAction.getComment());
        saa.setMethod(apiAction.getMethod());
        saa.setDocTags(apiAction.getDocTags());
        if (isjson || apiAction.getMethod().getAnnotation(ResponseBody.class) != null) {
            saa.setJson(true);
        }
        saa.setTitle(this.getTitile(saa));
        saa.setRespbody(this.getRespbody(saa));
        boolean isMappingMethod = this.setUrisAndMethods(apiAction, saa);
        if (!isMappingMethod) {
            return null;
        }
        saa.setParam(this.getParams(saa));
        saa.setRespParam(this.getRespParam(saa));
        saa.setReturnObj(this.getReturnObj(saa));
        saa.setReturnDesc(this.getReturnDesc(saa));
        return saa;
    }

    private boolean setUrisAndMethods(ApiAction apiAction, SpringApiAction saa) {
        RequestMapping methodRequestMappingAnno = apiAction.getMethod().getAnnotation(RequestMapping.class);
        if (methodRequestMappingAnno != null) {
            String[] urls = methodRequestMappingAnno.value();
            this.addSprit(urls);
            saa.setUris(this.getUris(urls));
            saa.setMethods(this.getMethods(methodRequestMappingAnno.method()));
            return true;
        }
        PostMapping postMapping = apiAction.getMethod().getAnnotation(PostMapping.class);
        if (postMapping != null) {
            String[] urls = postMapping.value();
            this.addSprit(urls);
            saa.setUris(this.getUris(urls));
            saa.setMethods(this.getMethods(RequestMethod.POST));
            return true;
        }
        GetMapping getMapping = apiAction.getMethod().getAnnotation(GetMapping.class);
        if (getMapping != null) {
            String[] urls = getMapping.value();
            this.addSprit(urls);
            saa.setUris(this.getUris(urls));
            saa.setMethods(this.getMethods(RequestMethod.GET));
            return true;
        }
        PutMapping putMapping = apiAction.getMethod().getAnnotation(PutMapping.class);
        if (putMapping != null) {
            String[] urls = putMapping.value();
            this.addSprit(urls);
            saa.setUris(this.getUris(urls));
            saa.setMethods(this.getMethods(RequestMethod.PUT));
            return true;
        }
        DeleteMapping deleteMapping = apiAction.getMethod().getAnnotation(DeleteMapping.class);
        if (deleteMapping != null) {
            String[] urls = deleteMapping.value();
            this.addSprit(urls);
            saa.setUris(this.getUris(urls));
            saa.setMethods(this.getMethods(RequestMethod.DELETE));
            return true;
        }
        PatchMapping patchMapping = apiAction.getMethod().getAnnotation(PatchMapping.class);
        if (patchMapping != null) {
            String[] urls = patchMapping.value();
            this.addSprit(urls);
            saa.setUris(this.getUris(urls));
            saa.setMethods(this.getMethods(RequestMethod.PATCH));
            return true;
        }
        return false;
    }

    protected String getReturnDesc(SpringApiAction saa) {
        AbstractDocTag tag = saa.getDocTags().getTag("@return");
        return tag != null ? tag.getValues().toString() : null;
    }

    protected ObjectInfo getReturnObj(SpringApiAction saa) {
        SeeTagImpl tag = (SeeTagImpl)saa.getDocTags().getTag("@see");
        return tag != null ? tag.getValues() : null;
    }

    protected List<ParamInfo> getParams(SpringApiAction saa) {
        List tags = saa.getDocTags().getTags("@param");
        ArrayList<ParamInfo> paramInfos = new ArrayList<ParamInfo>(tags.size());
        for (Object tag : tags) {
            ParamTagImpl paramTag = (ParamTagImpl)tag;
            ParamInfo paramInfo = new ParamInfo();
            paramInfo.setParamName(paramTag.getParamName());
            paramInfo.setParamDesc(paramTag.getParamDesc());
            paramInfo.setParamType(paramTag.getParamType());
            paramInfo.setRequire(paramTag.isRequire());
            paramInfos.add(paramInfo);
        }
        return paramInfos;
    }

    protected List<ParamInfo> getRespParam(SpringApiAction saa) {
        List tags = saa.getDocTags().getTags("@resp");
        ArrayList<ParamInfo> list = new ArrayList<ParamInfo>(tags.size());
        for (AbstractDocTag tag : tags) {
            RespTagImpl respTag = (RespTagImpl)tag;
            ParamInfo paramInfo = new ParamInfo();
            paramInfo.setParamName(respTag.getParamName());
            paramInfo.setRequire(respTag.isRequire());
            paramInfo.setParamDesc(respTag.getParamDesc());
            paramInfo.setParamType(respTag.getParamType());
            list.add(paramInfo);
        }
        return list;
    }

    protected String getRespbody(SpringApiAction saa) {
        AbstractDocTag respbodyTag = saa.getDocTags().getTag("@respbody");
        if (respbodyTag != null) {
            return (String)respbodyTag.getValues();
        }
        return null;
    }

    protected String getTitile(SpringApiAction saa) {
        AbstractDocTag titleTag = saa.getDocTags().getTag("@title");
        if (titleTag != null) {
            return (String)titleTag.getValues();
        }
        return saa.getComment();
    }

    protected List<String> getUris(String[] values) {
        ArrayList<String> uris = new ArrayList<String>();
        for (String value : values) {
            uris.add(value);
        }
        return uris;
    }

    protected List<String> getMethods(RequestMethod ... methods) {
        ArrayList<String> methodStrs = new ArrayList<String>();
        for (RequestMethod requestMethod : methods) {
            methodStrs.add(requestMethod.name());
        }
        return methodStrs;
    }

    protected boolean isJson(Class<?> classz) {
        Controller controllerAnno = classz.getAnnotation(Controller.class);
        RestController restControllerAnno = classz.getAnnotation(RestController.class);
        ResponseBody responseBody = classz.getAnnotation(ResponseBody.class);
        if (responseBody != null) {
            return true;
        }
        if (controllerAnno != null) {
            return false;
        }
        return restControllerAnno != null;
    }
}

