/*
 * Decompiled with CFR 0.152.
 */
package com.uifuture.superspring.format;

import com.uifuture.supercore.format.Format;
import com.uifuture.supercore.model.ApiAction;
import com.uifuture.supercore.model.ApiDoc;
import com.uifuture.supercore.model.ApiModule;
import com.uifuture.supercore.utils.JsonFormatUtils;
import com.uifuture.superspring.format.VelocityTemplater;
import com.uifuture.superspring.framework.SpringApiAction;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MarkdownFormat
implements Format {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private VelocityTemplater templater = new VelocityTemplater("com/uifuture/superspring/format/api.vm");

    public String format(ApiDoc apiDoc) {
        StringBuilder sb = new StringBuilder();
        for (ApiModule apiModule : apiDoc.getApiModules()) {
            sb.append(this.format(apiModule)).append("\n\n");
        }
        return sb.toString();
    }

    private String format(ApiModule apiModule) {
        for (ApiAction apiAction : apiModule.getApiActions()) {
            SpringApiAction saa = (SpringApiAction)apiAction;
            if (!saa.isJson() || !StringUtils.isNotBlank((CharSequence)saa.getRespbody())) continue;
            saa.setRespbody(JsonFormatUtils.formatJson((String)saa.getRespbody()));
        }
        try {
            Map map = PropertyUtils.describe((Object)apiModule);
            return this.templater.parse(map);
        }
        catch (Exception e) {
            this.log.error("\u8f93\u51famarkdown\u6587\u6863\u683c\u5f0f\u5931\u8d25", (Throwable)e);
            return null;
        }
    }
}

