/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.tione.v20191022.models;

import com.tencentcloudapi.common.AbstractModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class StartNotebookInstanceRequest extends AbstractModel{

    /**
    * Notebook实例名称
规则：^[a-zA-Z0-9](-*[a-zA-Z0-9])*$
    */
    @SerializedName("NotebookInstanceName")
    @Expose
    private String NotebookInstanceName;

    /**
    * 自动停止，可取值Enabled/Disabled
取值为Disabled的时候StoppingCondition将被忽略
取值为Enabled的时候读取StoppingCondition作为自动停止的配置
    */
    @SerializedName("AutoStopping")
    @Expose
    private String AutoStopping;

    /**
    * 自动停止配置，只在AutoStopping为Enabled的时候生效
    */
    @SerializedName("StoppingCondition")
    @Expose
    private StoppingCondition StoppingCondition;

    /**
     * Get Notebook实例名称
规则：^[a-zA-Z0-9](-*[a-zA-Z0-9])*$ 
     * @return NotebookInstanceName Notebook实例名称
规则：^[a-zA-Z0-9](-*[a-zA-Z0-9])*$
     */
    public String getNotebookInstanceName() {
        return this.NotebookInstanceName;
    }

    /**
     * Set Notebook实例名称
规则：^[a-zA-Z0-9](-*[a-zA-Z0-9])*$
     * @param NotebookInstanceName Notebook实例名称
规则：^[a-zA-Z0-9](-*[a-zA-Z0-9])*$
     */
    public void setNotebookInstanceName(String NotebookInstanceName) {
        this.NotebookInstanceName = NotebookInstanceName;
    }

    /**
     * Get 自动停止，可取值Enabled/Disabled
取值为Disabled的时候StoppingCondition将被忽略
取值为Enabled的时候读取StoppingCondition作为自动停止的配置 
     * @return AutoStopping 自动停止，可取值Enabled/Disabled
取值为Disabled的时候StoppingCondition将被忽略
取值为Enabled的时候读取StoppingCondition作为自动停止的配置
     */
    public String getAutoStopping() {
        return this.AutoStopping;
    }

    /**
     * Set 自动停止，可取值Enabled/Disabled
取值为Disabled的时候StoppingCondition将被忽略
取值为Enabled的时候读取StoppingCondition作为自动停止的配置
     * @param AutoStopping 自动停止，可取值Enabled/Disabled
取值为Disabled的时候StoppingCondition将被忽略
取值为Enabled的时候读取StoppingCondition作为自动停止的配置
     */
    public void setAutoStopping(String AutoStopping) {
        this.AutoStopping = AutoStopping;
    }

    /**
     * Get 自动停止配置，只在AutoStopping为Enabled的时候生效 
     * @return StoppingCondition 自动停止配置，只在AutoStopping为Enabled的时候生效
     */
    public StoppingCondition getStoppingCondition() {
        return this.StoppingCondition;
    }

    /**
     * Set 自动停止配置，只在AutoStopping为Enabled的时候生效
     * @param StoppingCondition 自动停止配置，只在AutoStopping为Enabled的时候生效
     */
    public void setStoppingCondition(StoppingCondition StoppingCondition) {
        this.StoppingCondition = StoppingCondition;
    }

    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "NotebookInstanceName", this.NotebookInstanceName);
        this.setParamSimple(map, prefix + "AutoStopping", this.AutoStopping);
        this.setParamObj(map, prefix + "StoppingCondition.", this.StoppingCondition);

    }
}

