/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.sun.security.rsa;

import com.tencent.kona.sun.security.jca.JCAUtil;
import com.tencent.kona.sun.security.rsa.RSAKeyFactory;
import com.tencent.kona.sun.security.rsa.RSAPrivateCrtKeyImpl;
import com.tencent.kona.sun.security.rsa.RSAPublicKeyImpl;
import com.tencent.kona.sun.security.rsa.RSAUtil;
import com.tencent.kona.sun.security.util.SecurityProviderConstants;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGeneratorSpi;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.RSAKeyGenParameterSpec;

abstract class RSAKeyPairGenerator
extends KeyPairGeneratorSpi {
    private static final BigInteger TWO = BigInteger.valueOf(2L);
    private static final BigInteger SQRT_2048 = new BigInteger("b504f333f9de6484597d89b3754abe9f1d6f60ba893ba84ced17ac85833399154afc83043ab8a2c3a8b1fe6fdc83db390f74a85e439c7b4a780487363dfa2768d2202e8742af1f4e53059c6011bc337bcab1bc911688458a460abc722f7c4e33c6d5a8a38bb7e9dccb2a634331f3c84df52f120f836e582eeaa4a0899040ca4a", 16);
    private static final BigInteger SQRT_3072 = new BigInteger("b504f333f9de6484597d89b3754abe9f1d6f60ba893ba84ced17ac85833399154afc83043ab8a2c3a8b1fe6fdc83db390f74a85e439c7b4a780487363dfa2768d2202e8742af1f4e53059c6011bc337bcab1bc911688458a460abc722f7c4e33c6d5a8a38bb7e9dccb2a634331f3c84df52f120f836e582eeaa4a0899040ca4a81394ab6d8fd0efdf4d3a02cebc93e0c4264dabcd528b651b8cf341b6f8236c70104dc01fe32352f332a5e9f7bda1ebff6a1be3fca221307dea06241f7aa81c2", 16);
    private static final BigInteger SQRT_4096 = new BigInteger("b504f333f9de6484597d89b3754abe9f1d6f60ba893ba84ced17ac85833399154afc83043ab8a2c3a8b1fe6fdc83db390f74a85e439c7b4a780487363dfa2768d2202e8742af1f4e53059c6011bc337bcab1bc911688458a460abc722f7c4e33c6d5a8a38bb7e9dccb2a634331f3c84df52f120f836e582eeaa4a0899040ca4a81394ab6d8fd0efdf4d3a02cebc93e0c4264dabcd528b651b8cf341b6f8236c70104dc01fe32352f332a5e9f7bda1ebff6a1be3fca221307dea06241f7aa81c2c1fcbddea2f7dc3318838a2eaff5f3b2d24f4a763facb882fdfe170fd3b1f780f9acce41797f2805c246785e929570235fcf8f7bca3ea33b4d7c60a5e633e3e1", 16);
    private BigInteger publicExponent;
    private int keySize;
    private final RSAUtil.KeyType type;
    private AlgorithmParameterSpec keyParams;
    private SecureRandom random;
    private boolean useNew;

    RSAKeyPairGenerator(RSAUtil.KeyType type, int defKeySize) {
        this.type = type;
        this.initialize(defKeySize, null);
    }

    @Override
    public void initialize(int keySize, SecureRandom random) {
        try {
            this.initialize(new RSAKeyGenParameterSpec(keySize, RSAKeyGenParameterSpec.F4), random);
        }
        catch (InvalidAlgorithmParameterException iape) {
            throw new InvalidParameterException(iape.getMessage());
        }
    }

    @Override
    public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        boolean useNew;
        if (!(params instanceof RSAKeyGenParameterSpec)) {
            throw new InvalidAlgorithmParameterException("Params must be instance of RSAKeyGenParameterSpec");
        }
        RSAKeyGenParameterSpec rsaSpec = (RSAKeyGenParameterSpec)params;
        int tmpKeySize = rsaSpec.getKeysize();
        BigInteger tmpPubExp = rsaSpec.getPublicExponent();
        AlgorithmParameterSpec tmpParams = RSAUtil.SUPPORT_PSS ? rsaSpec.getKeyParams() : null;
        boolean bl = useNew = tmpKeySize >= 2048 && (tmpKeySize & 1) == 0;
        if (tmpPubExp == null) {
            tmpPubExp = RSAKeyGenParameterSpec.F4;
        } else {
            if (!tmpPubExp.testBit(0)) {
                throw new InvalidAlgorithmParameterException("Public exponent must be an odd number");
            }
            BigInteger minValue = RSAKeyGenParameterSpec.F0;
            if (tmpPubExp.compareTo(RSAKeyGenParameterSpec.F0) < 0) {
                throw new InvalidAlgorithmParameterException("Public exponent must be " + minValue + " or larger");
            }
            if (tmpPubExp.bitLength() > tmpKeySize) {
                throw new InvalidAlgorithmParameterException("Public exponent must be no longer than " + tmpKeySize + " bits");
            }
            useNew &= tmpPubExp.compareTo(RSAKeyGenParameterSpec.F4) >= 0 && tmpPubExp.bitLength() < 256;
        }
        try {
            RSAKeyFactory.checkKeyLengths(tmpKeySize, tmpPubExp, 512, 65536);
        }
        catch (InvalidKeyException e) {
            throw new InvalidAlgorithmParameterException("Invalid key sizes", e);
        }
        try {
            this.keyParams = RSAUtil.checkParamsAgainstType(this.type, tmpParams);
        }
        catch (ProviderException e) {
            throw new InvalidAlgorithmParameterException("Invalid key parameters", e);
        }
        this.keySize = tmpKeySize;
        this.publicExponent = tmpPubExp;
        this.random = random == null ? JCAUtil.getSecureRandom() : random;
        this.useNew = useNew;
    }

    @Override
    public KeyPair generateKeyPair() {
        KeyPair kp;
        BigInteger q;
        BigInteger p;
        BigInteger n;
        BigInteger e = this.publicExponent;
        BigInteger minValue = this.useNew ? RSAKeyPairGenerator.getSqrt(this.keySize) : BigInteger.ZERO;
        int lp = this.keySize + 1 >> 1;
        int lq = this.keySize - lp;
        int pqDiffSize = lp - 100;
        do {
            p = null;
            q = null;
            int i = 0;
            while (i++ < 10 * lp) {
                BigInteger tmpP = BigInteger.probablePrime(lp, this.random);
                if (this.useNew && tmpP.compareTo(minValue) != 1 || !RSAKeyPairGenerator.isRelativePrime(e, tmpP.subtract(BigInteger.ONE))) continue;
                p = tmpP;
                break;
            }
            if (p == null) {
                throw new ProviderException("Cannot find prime P");
            }
            i = 0;
            while (i++ < 20 * lq) {
                BigInteger tmpQ = BigInteger.probablePrime(lq, this.random);
                if (this.useNew && tmpQ.compareTo(minValue) != 1 || p.subtract(tmpQ).abs().compareTo(TWO.pow(pqDiffSize)) != 1 || !RSAKeyPairGenerator.isRelativePrime(e, tmpQ.subtract(BigInteger.ONE))) continue;
                q = tmpQ;
                break;
            }
            if (q != null) continue;
            throw new ProviderException("Cannot find prime Q");
        } while ((n = p.multiply(q)).bitLength() != this.keySize || (kp = RSAKeyPairGenerator.createKeyPair(this.type, this.keyParams, n, e, p, q)) == null);
        return kp;
    }

    private static BigInteger getSqrt(int keySize) {
        BigInteger sqrt;
        switch (keySize) {
            case 2048: {
                sqrt = SQRT_2048;
                break;
            }
            case 3072: {
                sqrt = SQRT_3072;
                break;
            }
            case 4096: {
                sqrt = SQRT_4096;
                break;
            }
            default: {
                throw new IllegalArgumentException("keySize must be 2048, 3072 or 4096");
            }
        }
        return sqrt;
    }

    private static boolean isRelativePrime(BigInteger e, BigInteger bi) {
        if (e.compareTo(RSAKeyGenParameterSpec.F4) == 0 || e.compareTo(RSAKeyGenParameterSpec.F0) == 0) {
            return !bi.mod(e).equals(BigInteger.ZERO);
        }
        return e.gcd(bi).equals(BigInteger.ONE);
    }

    private static KeyPair createKeyPair(RSAUtil.KeyType type, AlgorithmParameterSpec keyParams, BigInteger n, BigInteger e, BigInteger p, BigInteger q) {
        BigInteger p1 = p.subtract(BigInteger.ONE);
        BigInteger q1 = q.subtract(BigInteger.ONE);
        BigInteger phi = p1.multiply(q1);
        BigInteger gcd = p1.gcd(q1);
        BigInteger lcm = gcd.equals(BigInteger.ONE) ? phi : phi.divide(gcd);
        BigInteger d = e.modInverse(lcm);
        if (d.compareTo(TWO.pow(p.bitLength())) != 1) {
            return null;
        }
        BigInteger pe = d.mod(p1);
        BigInteger qe = d.mod(q1);
        BigInteger coeff = q.modInverse(p);
        try {
            RSAPublicKeyImpl publicKey = new RSAPublicKeyImpl(type, keyParams, n, e);
            RSAPrivateCrtKeyImpl privateKey = new RSAPrivateCrtKeyImpl(type, keyParams, n, e, d, p, q, pe, qe, coeff);
            return new KeyPair(publicKey, privateKey);
        }
        catch (InvalidKeyException exc) {
            throw new RuntimeException(exc);
        }
    }

    public static final class PSS
    extends RSAKeyPairGenerator {
        public PSS() {
            super(RSAUtil.KeyType.PSS, SecurityProviderConstants.DEF_RSASSA_PSS_KEY_SIZE);
        }
    }

    public static final class Legacy
    extends RSAKeyPairGenerator {
        public Legacy() {
            super(RSAUtil.KeyType.RSA, SecurityProviderConstants.DEF_RSA_KEY_SIZE);
        }
    }
}

