/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.sun.security.ec.point;

import com.tencent.kona.sun.security.util.math.ImmutableIntegerModuloP;
import com.tencent.kona.sun.security.util.math.IntegerFieldModuloP;
import com.tencent.kona.sun.security.util.math.IntegerMontgomeryFieldModuloP;
import java.security.spec.ECPoint;
import java.util.Objects;

public class AffinePoint {
    private final ImmutableIntegerModuloP x;
    private final ImmutableIntegerModuloP y;

    public AffinePoint(ImmutableIntegerModuloP x, ImmutableIntegerModuloP y) {
        this.x = x;
        this.y = y;
    }

    public static AffinePoint fromECPoint(ECPoint ecPoint, IntegerFieldModuloP field) {
        return new AffinePoint(field.getElement(ecPoint.getAffineX()), field.getElement(ecPoint.getAffineY()));
    }

    public ECPoint toECPoint() {
        return new ECPoint(this.getX().asBigInteger(), this.getY().asBigInteger());
    }

    public ImmutableIntegerModuloP getX() {
        return this.getX(true);
    }

    public ImmutableIntegerModuloP getX(boolean fieldCheck) {
        IntegerFieldModuloP field = this.x.getField();
        if (fieldCheck && field instanceof IntegerMontgomeryFieldModuloP) {
            return ((IntegerMontgomeryFieldModuloP)field).fromMontgomery(this.x);
        }
        return this.x;
    }

    public ImmutableIntegerModuloP getY() {
        return this.getY(true);
    }

    public ImmutableIntegerModuloP getY(boolean fieldCheck) {
        IntegerFieldModuloP field = this.y.getField();
        if (fieldCheck && field instanceof IntegerMontgomeryFieldModuloP) {
            return ((IntegerMontgomeryFieldModuloP)field).fromMontgomery(this.y);
        }
        return this.y;
    }

    public boolean equals(Object obj) {
        boolean yEquals;
        boolean xEquals;
        boolean objMont;
        if (!(obj instanceof AffinePoint)) {
            return false;
        }
        AffinePoint p = (AffinePoint)obj;
        boolean thisMont = this.x.getField() instanceof IntegerMontgomeryFieldModuloP;
        if (thisMont ^ !(objMont = p.x.getField() instanceof IntegerMontgomeryFieldModuloP)) {
            xEquals = this.x.asBigInteger().equals(p.x.asBigInteger());
            yEquals = this.y.asBigInteger().equals(p.y.asBigInteger());
        } else if (thisMont) {
            IntegerMontgomeryFieldModuloP field = (IntegerMontgomeryFieldModuloP)this.x.getField();
            xEquals = this.x.asBigInteger().equals(field.getElement(p.x.asBigInteger()).asBigInteger());
            yEquals = this.y.asBigInteger().equals(field.getElement(p.y.asBigInteger()).asBigInteger());
        } else {
            IntegerMontgomeryFieldModuloP field = (IntegerMontgomeryFieldModuloP)p.x.getField();
            xEquals = field.getElement(this.x.asBigInteger()).asBigInteger().equals(p.x.asBigInteger());
            yEquals = field.getElement(this.y.asBigInteger()).asBigInteger().equals(p.y.asBigInteger());
        }
        return xEquals && yEquals;
    }

    public int hashCode() {
        return Objects.hash(this.x, this.y);
    }

    public String toString() {
        return "(" + this.x.asBigInteger().toString() + "," + this.y.asBigInteger().toString() + ")";
    }
}

