/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.crypto.provider.nativeImpl;

import com.tencent.kona.crypto.provider.nativeImpl.NativeSM3HMac;
import com.tencent.kona.crypto.provider.nativeImpl.SweepNativeRef;
import com.tencent.kona.crypto.util.Sweeper;
import com.tencent.kona.jdk.internal.util.Preconditions;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.MacSpi;
import javax.crypto.SecretKey;

public final class SM3HMac
extends MacSpi
implements Cloneable {
    private static final Sweeper SWEEPER = Sweeper.instance();
    private NativeSM3HMac sm3HMac;

    @Override
    protected int engineGetMacLength() {
        return 32;
    }

    @Override
    protected void engineInit(Key key, AlgorithmParameterSpec params) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (params != null) {
            throw new InvalidAlgorithmParameterException("No need parameters");
        }
        if (!(key instanceof SecretKey)) {
            throw new InvalidKeyException("SecretKey is expected");
        }
        byte[] secret = key.getEncoded();
        if (secret == null) {
            throw new InvalidKeyException("No key data");
        }
        this.sm3HMac = new NativeSM3HMac(secret);
        SWEEPER.register(this, new SweepNativeRef(this.sm3HMac));
    }

    @Override
    protected void engineUpdate(byte input) {
        this.sm3HMac.update(new byte[]{input});
    }

    @Override
    protected void engineUpdate(byte[] input, int offset, int len) {
        if (len == 0) {
            return;
        }
        Preconditions.checkFromIndexSize(offset, len, input.length, Preconditions.AIOOBE_FORMATTER);
        byte[] data = new byte[len];
        System.arraycopy(input, offset, data, 0, len);
        this.sm3HMac.update(data);
    }

    @Override
    protected byte[] engineDoFinal() {
        return this.sm3HMac.doFinal();
    }

    @Override
    protected void engineReset() {
        this.sm3HMac.reset();
    }

    @Override
    public SM3HMac clone() throws CloneNotSupportedException {
        SM3HMac clone = (SM3HMac)super.clone();
        clone.sm3HMac = this.sm3HMac.clone();
        return clone;
    }
}

