/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.crypto.provider.nativeImpl;

import com.tencent.kona.crypto.provider.SM2PrivateKey;
import com.tencent.kona.crypto.provider.SM2PublicKey;
import com.tencent.kona.crypto.provider.nativeImpl.ByteArrayWriter;
import com.tencent.kona.crypto.provider.nativeImpl.NativeSM2Signature;
import com.tencent.kona.crypto.provider.nativeImpl.SweepNativeRef;
import com.tencent.kona.crypto.spec.SM2ParameterSpec;
import com.tencent.kona.crypto.spec.SM2SignatureParameterSpec;
import com.tencent.kona.crypto.util.Sweeper;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;

public final class SM2Signature
extends SignatureSpi {
    private static final byte[] DEFAULT_ID = new byte[]{49, 50, 51, 52, 53, 54, 55, 56, 49, 50, 51, 52, 53, 54, 55, 56};
    private static final Sweeper SWEEPER = Sweeper.instance();
    private NativeSM2Signature sm2;
    private SM2PrivateKey privateKey;
    private SM2PublicKey publicKey;
    private byte[] id;
    private final ByteArrayWriter buffer = new ByteArrayWriter();

    @Override
    protected void engineInitSign(PrivateKey privateKey, SecureRandom random) throws InvalidKeyException {
        this.sm2 = null;
        this.privateKey = null;
        this.buffer.reset();
        if (!(privateKey instanceof ECPrivateKey)) {
            throw new InvalidKeyException("Only ECPrivateKey accepted!");
        }
        ECPrivateKey ecPrivateKey = (ECPrivateKey)privateKey;
        BigInteger s = ecPrivateKey.getS();
        if (s.compareTo(BigInteger.ZERO) <= 0 || s.compareTo(SM2ParameterSpec.ORDER.subtract(BigInteger.ONE)) >= 0) {
            throw new InvalidKeyException("The private key must be within the range [1, n - 2]");
        }
        this.privateKey = new SM2PrivateKey(ecPrivateKey);
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        this.engineInitSign(privateKey, null);
    }

    @Override
    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        this.privateKey = null;
        this.publicKey = null;
        this.buffer.reset();
        if (!(publicKey instanceof ECPublicKey)) {
            throw new InvalidKeyException("Only ECPublicKey accepted!");
        }
        this.publicKey = new SM2PublicKey((ECPublicKey)publicKey);
    }

    @Override
    protected void engineSetParameter(AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
        this.privateKey = null;
        this.publicKey = null;
        this.id = null;
        if (!(params instanceof SM2SignatureParameterSpec)) {
            throw new InvalidAlgorithmParameterException("Only accept SM2SignatureParameterSpec");
        }
        SM2SignatureParameterSpec paramSpec = (SM2SignatureParameterSpec)params;
        this.publicKey = new SM2PublicKey(paramSpec.getPublicKey());
        this.id = paramSpec.getId();
    }

    @Override
    protected void engineSetParameter(String param, Object value) throws InvalidParameterException {
        throw new UnsupportedOperationException("Use setParameter(AlgorithmParameterSpec params) instead");
    }

    @Override
    protected Object engineGetParameter(String param) throws InvalidParameterException {
        throw new UnsupportedOperationException("getParameter(String param) not supported");
    }

    @Override
    protected void engineUpdate(byte b) throws SignatureException {
        byte[] buf = new byte[]{b};
        this.buffer.write(buf, 0, 1);
    }

    @Override
    protected void engineUpdate(byte[] b, int off, int len) throws SignatureException {
        this.buffer.write(b, off, len);
    }

    @Override
    protected byte[] engineSign() throws SignatureException {
        if (this.privateKey == null) {
            throw new SignatureException("Private key not initialized");
        }
        if (this.id == null) {
            this.id = (byte[])DEFAULT_ID.clone();
        }
        if (this.sm2 == null) {
            this.sm2 = new NativeSM2Signature(this.privateKey.getEncoded(), this.publicKey != null ? this.publicKey.getEncoded() : null, this.id, true);
            SWEEPER.register(this, new SweepNativeRef(this.sm2));
        }
        try {
            byte[] byArray = this.sm2.sign(this.buffer.toByteArray());
            return byArray;
        }
        catch (BadPaddingException e) {
            throw new SignatureException(e);
        }
        finally {
            this.buffer.reset();
        }
    }

    @Override
    protected boolean engineVerify(byte[] sigBytes) throws SignatureException {
        if (this.publicKey == null) {
            throw new SignatureException("Public key not initialized");
        }
        if (this.id == null) {
            this.id = (byte[])DEFAULT_ID.clone();
        }
        if (this.sm2 == null) {
            this.sm2 = new NativeSM2Signature(null, this.publicKey.getEncoded(), this.id, false);
            SWEEPER.register(this, new SweepNativeRef(this.sm2));
        }
        try {
            boolean bl = this.sm2.verify(this.buffer.toByteArray(), sigBytes);
            return bl;
        }
        catch (BadPaddingException e) {
            throw new SignatureException(e);
        }
        finally {
            this.buffer.reset();
        }
    }
}

