/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.crypto.provider.nativeImpl;

import com.tencent.kona.crypto.provider.SM2PrivateKey;
import com.tencent.kona.crypto.provider.SM2PublicKey;
import com.tencent.kona.crypto.provider.nativeImpl.NativeCrypto;
import com.tencent.kona.crypto.spec.SM2KeyAgreementParamSpec;
import com.tencent.kona.crypto.spec.SM2ParameterSpec;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyAgreementSpi;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.SecretKeySpec;

public final class SM2OneShotKeyAgreement
extends KeyAgreementSpi {
    private SM2PrivateKey ephemeralPrivateKey;
    private SM2KeyAgreementParamSpec paramSpec;
    private SM2PublicKey peerEphemeralPublicKey;

    @Override
    protected void engineInit(Key key, SecureRandom random) {
        throw new UnsupportedOperationException("Use init(Key, AlgorithmParameterSpec, SecureRandom) instead");
    }

    @Override
    protected void engineInit(Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.ephemeralPrivateKey = null;
        this.paramSpec = null;
        this.peerEphemeralPublicKey = null;
        if (!(key instanceof ECPrivateKey)) {
            throw new InvalidKeyException("Only accept ECPrivateKey");
        }
        if (!(params instanceof SM2KeyAgreementParamSpec)) {
            throw new InvalidAlgorithmParameterException("Only accept SM2KeyAgreementParamSpec");
        }
        ECPrivateKey ecPrivateKey = (ECPrivateKey)key;
        BigInteger s = ecPrivateKey.getS();
        if (s.compareTo(BigInteger.ZERO) <= 0 || s.compareTo(SM2ParameterSpec.ORDER) >= 0) {
            throw new InvalidKeyException("The private key must be within the range [1, n - 1]");
        }
        this.ephemeralPrivateKey = new SM2PrivateKey((ECPrivateKey)key);
        this.paramSpec = (SM2KeyAgreementParamSpec)params;
        this.peerEphemeralPublicKey = null;
    }

    @Override
    protected Key engineDoPhase(Key key, boolean lastPhase) throws InvalidKeyException, IllegalStateException {
        if (this.ephemeralPrivateKey == null || this.paramSpec == null) {
            throw new IllegalStateException("Not initialized");
        }
        if (this.peerEphemeralPublicKey != null) {
            throw new IllegalStateException("Phase already executed");
        }
        if (!lastPhase) {
            throw new IllegalStateException("Only two party agreement supported, lastPhase must be true");
        }
        if (!(key instanceof ECPublicKey)) {
            throw new InvalidKeyException("Only accept ECPublicKey");
        }
        SM2PublicKey sm2PublicKey = new SM2PublicKey((ECPublicKey)key);
        if (NativeCrypto.sm2ValidatePoint(sm2PublicKey.getEncoded()) != 1) {
            throw new InvalidKeyException("Public key is invalid");
        }
        this.peerEphemeralPublicKey = sm2PublicKey;
        return null;
    }

    @Override
    protected byte[] engineGenerateSecret() throws IllegalStateException {
        byte[] result;
        if (this.ephemeralPrivateKey == null || this.peerEphemeralPublicKey == null) {
            throw new IllegalStateException("Not initialized correctly");
        }
        try {
            result = this.deriveKeyImpl();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        this.peerEphemeralPublicKey = null;
        return result;
    }

    private byte[] deriveKeyImpl() {
        return NativeCrypto.sm2OneShotDeriveKey(new SM2PrivateKey(this.paramSpec.privateKey()).getEncoded(), new SM2PublicKey(this.paramSpec.publicKey()).getEncoded(), this.ephemeralPrivateKey.getEncoded(), this.paramSpec.id(), new SM2PublicKey(this.paramSpec.peerPublicKey()).getEncoded(), this.peerEphemeralPublicKey.getEncoded(), this.paramSpec.peerId(), this.paramSpec.isInitiator(), this.paramSpec.sharedKeyLength());
    }

    @Override
    protected int engineGenerateSecret(byte[] sharedSecret, int offset) throws IllegalStateException, ShortBufferException {
        if (offset + this.paramSpec.sharedKeyLength() > sharedSecret.length) {
            throw new ShortBufferException("Need " + this.paramSpec.sharedKeyLength() + " bytes, only " + (sharedSecret.length - offset) + " available");
        }
        byte[] secret = this.engineGenerateSecret();
        System.arraycopy(secret, 0, sharedSecret, offset, secret.length);
        return secret.length;
    }

    @Override
    protected SecretKey engineGenerateSecret(String algorithm) throws IllegalStateException, NoSuchAlgorithmException {
        if (algorithm == null) {
            throw new NoSuchAlgorithmException("Algorithm must not be null");
        }
        return new SecretKeySpec(this.engineGenerateSecret(), algorithm);
    }
}

