/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.crypto.provider.nativeImpl;

import com.tencent.kona.crypto.provider.nativeImpl.NativeCrypto;
import com.tencent.kona.crypto.provider.nativeImpl.NativeRef;

public class NativeSM2KeyAgreement
extends NativeRef {
    NativeSM2KeyAgreement() {
        super(NativeSM2KeyAgreement.createCtx());
    }

    private static long createCtx() {
        return NativeCrypto.nativeCrypto().sm2KeyExCreateCtx();
    }

    public byte[] deriveKey(byte[] priKey, byte[] pubKey, byte[] ePriKey, byte[] id, byte[] peerPubKey, byte[] peerEPubKey, byte[] peerId, boolean isInitiator, int sharedKeyLength) throws IllegalStateException {
        byte[] sharedKey;
        if (priKey == null || priKey.length == 0 || pubKey == null || pubKey.length == 0 || ePriKey == null || ePriKey.length == 0 || id == null || id.length == 0 || peerPubKey == null || peerPubKey.length == 0 || peerEPubKey == null || peerEPubKey.length == 0 || peerId == null || peerId.length == 0) {
            throw new IllegalStateException("Cannot generate shared key");
        }
        if (sharedKeyLength <= 0) {
            throw new IllegalStateException("Shared key length must be greater than 0");
        }
        byte[] byArray = sharedKey = this.pointer == 0L ? null : NativeCrypto.nativeCrypto().sm2DeriveKey(this.pointer, priKey, pubKey, ePriKey, id, peerPubKey, peerEPubKey, peerId, isInitiator, sharedKeyLength);
        if (sharedKey == null) {
            throw new IllegalStateException("Cannot generate shared key");
        }
        return sharedKey;
    }

    @Override
    public void close() {
        if (this.pointer != 0L) {
            NativeCrypto.nativeCrypto().sm2KeyExFreeCtx(this.pointer);
            super.close();
        }
    }
}

