/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.crypto.provider.nativeImpl;

import com.tencent.kona.crypto.provider.nativeImpl.NativeCrypto;
import com.tencent.kona.crypto.provider.nativeImpl.NativeRef;
import java.security.SignatureException;

public class NativeECDSASignature
extends NativeRef {
    NativeECDSASignature(int mdNID, int curveNID, byte[] key, boolean isSign) {
        super(NativeECDSASignature.createCtx(mdNID, curveNID, key, isSign));
    }

    private static long createCtx(int mdNID, int curveNID, byte[] key, boolean isSign) {
        if (key == null || key.length == 0) {
            throw new IllegalStateException("Key is null or empty");
        }
        return NativeCrypto.ecdsaCreateCtx(mdNID, curveNID, key, isSign);
    }

    public byte[] sign(byte[] message) throws SignatureException {
        byte[] signature;
        if (message == null) {
            throw new SignatureException("Message cannot be null");
        }
        byte[] byArray = signature = this.pointer == 0L ? null : NativeCrypto.ecdsaSign(this.pointer, message);
        if (signature == null) {
            throw new SignatureException("Sign failed");
        }
        return signature;
    }

    public boolean verify(byte[] message, byte[] signature) throws SignatureException {
        if (message == null) {
            throw new SignatureException("Message cannot be null");
        }
        if (signature == null || signature.length == 0) {
            throw new SignatureException("Invalid signature");
        }
        int verified = this.pointer == 0L ? 0 : NativeCrypto.ecdsaVerify(this.pointer, message, signature);
        return verified == 1;
    }

    @Override
    public void close() {
        if (this.pointer != 0L) {
            NativeCrypto.ecdsaFreeCtx(this.pointer);
            super.close();
        }
    }
}

