/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.crypto.provider.nativeImpl;

import com.tencent.kona.crypto.CryptoInsts;
import com.tencent.kona.crypto.provider.nativeImpl.ByteArrayWriter;
import com.tencent.kona.crypto.provider.nativeImpl.NativeCrypto;
import com.tencent.kona.crypto.util.Constants;
import com.tencent.kona.sun.security.ec.ECKeyFactory;
import com.tencent.kona.sun.security.ec.ECPrivateKeyImpl;
import com.tencent.kona.sun.security.util.ArrayUtil;
import com.tencent.kona.sun.security.util.ECUtil;
import java.nio.ByteBuffer;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;

abstract class KonaOneShotECDSASignature
extends SignatureSpi {
    private final int mdNID;
    private final ByteArrayWriter buffer = new ByteArrayWriter();
    private ECPrivateKey privateKey;
    private ECPublicKey publicKey;
    private ECParameterSpec sigParams = null;
    private final boolean p1363Format;

    KonaOneShotECDSASignature() {
        this(false);
    }

    KonaOneShotECDSASignature(boolean p1363Format) {
        this.mdNID = -1;
        this.p1363Format = p1363Format;
    }

    KonaOneShotECDSASignature(String digestName) {
        this(digestName, false);
    }

    KonaOneShotECDSASignature(String digestName, boolean p1363Format) {
        this.mdNID = Constants.getDigestNID(digestName);
        this.p1363Format = p1363Format;
    }

    @Override
    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        ECPublicKey key = (ECPublicKey)ECKeyFactory.toECKey(publicKey);
        if (!KonaOneShotECDSASignature.isCompatible(this.sigParams, key.getParams())) {
            throw new InvalidKeyException("Key params does not match signature params");
        }
        this.publicKey = key;
        this.privateKey = null;
        this.resetDigest();
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        this.engineInitSign(privateKey, null);
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey, SecureRandom random) throws InvalidKeyException {
        ECPrivateKey key = (ECPrivateKey)ECKeyFactory.toECKey(privateKey);
        if (!KonaOneShotECDSASignature.isCompatible(this.sigParams, key.getParams())) {
            throw new InvalidKeyException("Key params does not match signature params");
        }
        ECUtil.checkPrivateKey(key);
        this.privateKey = key;
        this.publicKey = null;
        this.resetDigest();
    }

    protected void resetDigest() {
        this.buffer.reset();
    }

    protected byte[] getDigestValue() throws SignatureException {
        return this.buffer.toByteArray();
    }

    @Override
    protected void engineUpdate(byte b) throws SignatureException {
        this.buffer.write(b);
    }

    @Override
    protected void engineUpdate(byte[] b, int off, int len) throws SignatureException {
        this.buffer.write(b, off, len);
    }

    @Override
    protected void engineUpdate(ByteBuffer byteBuffer) {
        super.engineUpdate(byteBuffer);
    }

    private static boolean isCompatible(ECParameterSpec sigParams, ECParameterSpec keyParams) {
        if (sigParams == null) {
            return true;
        }
        return ECUtil.equals(sigParams, keyParams);
    }

    private byte[] signDigestImpl(ECPrivateKey priv) throws SignatureException {
        byte[] s = priv instanceof ECPrivateKeyImpl ? ((ECPrivateKeyImpl)priv).getArrayS() : ECUtil.sArray(priv.getS(), priv.getParams());
        ArrayUtil.reverse(s);
        ECParameterSpec curveParam = priv.getParams();
        int curveNID = Constants.getCurveNID(curveParam.toString());
        byte[] message = this.buffer.toByteArray();
        this.buffer.reset();
        byte[] sig = NativeCrypto.ecdsaOneShotSign(this.mdNID, curveNID, s, message);
        if (sig == null || sig.length == 0) {
            throw new SignatureException("Unable to produce signature");
        }
        return sig;
    }

    @Override
    protected byte[] engineSign() throws SignatureException {
        byte[] sig = this.signDigestImpl(this.privateKey);
        if (this.p1363Format) {
            return ECUtil.decodeSignature(sig);
        }
        return sig;
    }

    @Override
    protected boolean engineVerify(byte[] signature) throws SignatureException {
        ECPoint w = this.publicKey.getW();
        ECParameterSpec params = this.publicKey.getParams();
        try {
            ECUtil.validatePublicKey(w, params);
        }
        catch (InvalidKeyException e) {
            return false;
        }
        byte[] publicKey = ECUtil.encodePoint(w, params.getCurve());
        byte[] sig = !this.p1363Format ? signature : ECUtil.decodeSignature(signature);
        int curveNID = Constants.getCurveNID(params.toString());
        byte[] message = this.buffer.toByteArray();
        this.buffer.reset();
        return NativeCrypto.ecdsaOneShotVerify(this.mdNID, curveNID, publicKey, message, sig) == 1;
    }

    @Override
    @Deprecated
    protected void engineSetParameter(String param, Object value) throws InvalidParameterException {
        throw new UnsupportedOperationException("setParameter() not supported");
    }

    @Override
    protected void engineSetParameter(AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
        Key key;
        if (params != null && !(params instanceof ECParameterSpec)) {
            throw new InvalidAlgorithmParameterException("No parameter accepted");
        }
        Key key2 = key = this.privateKey == null ? this.publicKey : this.privateKey;
        if (key != null && !KonaOneShotECDSASignature.isCompatible((ECParameterSpec)params, key.getParams())) {
            throw new InvalidAlgorithmParameterException("Signature params does not match key params");
        }
        this.sigParams = (ECParameterSpec)params;
    }

    @Override
    @Deprecated
    protected Object engineGetParameter(String param) throws InvalidParameterException {
        throw new UnsupportedOperationException("getParameter() not supported");
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        if (this.sigParams == null) {
            return null;
        }
        try {
            AlgorithmParameters ap = CryptoInsts.getAlgorithmParameters("EC");
            ap.init(this.sigParams);
            return ap;
        }
        catch (Exception e) {
            throw new ProviderException("Error retrieving EC parameters", e);
        }
    }

    public static final class SHA3_512inP1363Format
    extends KonaOneShotECDSASignature {
        public SHA3_512inP1363Format() {
            super("SHA3-512", true);
        }
    }

    public static final class SHA3_512
    extends KonaOneShotECDSASignature {
        public SHA3_512() {
            super("SHA3-512");
        }
    }

    public static final class SHA3_384inP1363Format
    extends KonaOneShotECDSASignature {
        public SHA3_384inP1363Format() {
            super("SHA3-384", true);
        }
    }

    public static final class SHA3_384
    extends KonaOneShotECDSASignature {
        public SHA3_384() {
            super("SHA3-384");
        }
    }

    public static final class SHA3_256inP1363Format
    extends KonaOneShotECDSASignature {
        public SHA3_256inP1363Format() {
            super("SHA3-256", true);
        }
    }

    public static final class SHA3_256
    extends KonaOneShotECDSASignature {
        public SHA3_256() {
            super("SHA3-256");
        }
    }

    public static final class SHA3_224inP1363Format
    extends KonaOneShotECDSASignature {
        public SHA3_224inP1363Format() {
            super("SHA3-224", true);
        }
    }

    public static final class SHA3_224
    extends KonaOneShotECDSASignature {
        public SHA3_224() {
            super("SHA3-224");
        }
    }

    public static final class SHA512inP1363Format
    extends KonaOneShotECDSASignature {
        public SHA512inP1363Format() {
            super("SHA-512", true);
        }
    }

    public static final class SHA512
    extends KonaOneShotECDSASignature {
        public SHA512() {
            super("SHA-512");
        }
    }

    public static final class SHA384inP1363Format
    extends KonaOneShotECDSASignature {
        public SHA384inP1363Format() {
            super("SHA-384", true);
        }
    }

    public static final class SHA384
    extends KonaOneShotECDSASignature {
        public SHA384() {
            super("SHA-384");
        }
    }

    public static final class SHA256inP1363Format
    extends KonaOneShotECDSASignature {
        public SHA256inP1363Format() {
            super("SHA-256", true);
        }
    }

    public static final class SHA256
    extends KonaOneShotECDSASignature {
        public SHA256() {
            super("SHA-256");
        }
    }

    public static final class SHA224inP1363Format
    extends KonaOneShotECDSASignature {
        public SHA224inP1363Format() {
            super("SHA-224", true);
        }
    }

    public static final class SHA224
    extends KonaOneShotECDSASignature {
        public SHA224() {
            super("SHA-224");
        }
    }

    public static final class SHA1inP1363Format
    extends KonaOneShotECDSASignature {
        public SHA1inP1363Format() {
            super("SHA1", true);
        }
    }

    public static final class SHA1
    extends KonaOneShotECDSASignature {
        public SHA1() {
            super("SHA1");
        }
    }

    public static final class RawinP1363Format
    extends RawECDSA {
        public RawinP1363Format() {
            super(true);
        }
    }

    public static final class Raw
    extends RawECDSA {
        public Raw() {
            super(false);
        }
    }

    static class RawECDSA
    extends KonaOneShotECDSASignature {
        private static final int RAW_ECDSA_MAX = 64;
        private final byte[] precomputedDigest = new byte[64];
        private int offset = 0;

        RawECDSA(boolean p1363Format) {
            super(p1363Format);
        }

        @Override
        protected void engineUpdate(byte b) throws SignatureException {
            if (this.offset >= this.precomputedDigest.length) {
                this.offset = 65;
                return;
            }
            this.precomputedDigest[this.offset++] = b;
        }

        @Override
        protected void engineUpdate(byte[] b, int off, int len) throws SignatureException {
            if (this.offset >= this.precomputedDigest.length) {
                this.offset = 65;
                return;
            }
            System.arraycopy(b, off, this.precomputedDigest, this.offset, len);
            this.offset += len;
        }

        @Override
        protected void engineUpdate(ByteBuffer byteBuffer) {
            int len = byteBuffer.remaining();
            if (len <= 0) {
                return;
            }
            if (len >= this.precomputedDigest.length - this.offset) {
                this.offset = 65;
                return;
            }
            byteBuffer.get(this.precomputedDigest, this.offset, len);
            this.offset += len;
        }

        @Override
        protected void resetDigest() {
            this.offset = 0;
        }

        @Override
        protected byte[] getDigestValue() throws SignatureException {
            if (this.offset > 64) {
                throw new SignatureException("Message digest is too long");
            }
            byte[] result = new byte[this.offset];
            System.arraycopy(this.precomputedDigest, 0, result, 0, this.offset);
            this.offset = 0;
            return result;
        }
    }
}

