/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.pandora.boot.maven.sar;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.taobao.pandora.boot.maven.sar.ScmSar;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;

class PandoraWebHelper {
    private static final String RECOMMENDED_SAR_URL = "http://ops.jm.taobao.org:9999/pandora-web/api/getRecommandSarVersion.do";
    private static final String SAR_INFO_URL = "http://ops.jm.taobao.org:9999/pandora-web/api/getSar.do";

    PandoraWebHelper() {
    }

    static String getRecommendedSarVersion() {
        return PandoraWebHelper.read(RECOMMENDED_SAR_URL);
    }

    static ScmSar querySarInfo(String version) {
        try {
            String info = PandoraWebHelper.read("http://ops.jm.taobao.org:9999/pandora-web/api/getSar.do?version=" + version);
            JSONObject o = JSON.parseObject((String)info);
            ScmSar scmSar = (ScmSar)o.getObject("sar", ScmSar.class);
            return scmSar;
        }
        catch (Throwable t) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String read(String url) {
        URLConnection connection = null;
        try {
            connection = new URL(url).openConnection();
            connection.setConnectTimeout(5000);
            connection.setReadTimeout(5000);
            connection.setRequestProperty("User-Agent", "Pandora Boot Dev Tools");
            connection.setUseCaches(false);
            InputStream is = connection.getInputStream();
            StringBuilder sb = new StringBuilder();
            byte[] buffer = new byte[1024];
            int len = -1;
            while ((len = is.read(buffer)) != -1) {
                sb.append(new String(buffer, 0, len));
            }
            String string = sb.toString().trim();
            return string;
        }
        catch (IOException is) {
        }
        finally {
            if (connection instanceof HttpURLConnection) {
                HttpURLConnection httpURLConnection = (HttpURLConnection)connection;
                httpURLConnection.disconnect();
            }
        }
        return "";
    }
}

