/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.pandora.boot.maven;

import com.taobao.pandora.boot.AutoConfigWrapper;
import com.taobao.pandora.boot.loader.LaunchRunner;
import com.taobao.pandora.boot.loader.ReLaunchMainLauncher;
import com.taobao.pandora.boot.loader.SarLauncher;
import com.taobao.pandora.boot.loader.SarLoaderUtils;
import com.taobao.pandora.boot.loader.jmx.mbean.Health;
import com.taobao.pandora.boot.loader.tools.JavaExecutable;
import com.taobao.pandora.boot.loader.tools.RunProcess;
import com.taobao.pandora.boot.maven.AbstractRunMojo;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="run", requiresProject=true, defaultPhase=LifecyclePhase.VALIDATE, requiresDependencyResolution=ResolutionScope.TEST)
@Execute(phase=LifecyclePhase.TEST_COMPILE)
public class RunMojo
extends AbstractRunMojo {
    private static final int EXIT_CODE_SIGINT = 130;
    private static final String RESTARTER_CLASS_LOCATION = "org/springframework/boot/devtools/restart/Restarter.class";
    private Boolean hasDevtools;
    @Parameter
    private String pandoraLocation;
    private URL[] classPathUrlsAfterAutoConfig = null;

    @Override
    protected boolean enableForkByDefault() {
        return super.enableForkByDefault() || this.hasDevtools();
    }

    @Override
    protected void logDisabledFork() {
        super.logDisabledFork();
        if (this.hasDevtools()) {
            this.getLog().warn((CharSequence)"Fork mode disabled, devtools will be disabled");
        }
    }

    @Override
    protected void runWithForkedJvm(File workingDirectory, List<String> args) throws MojoExecutionException {
        try {
            URL[] urls = this.getClassPathUrls();
            if (this.isPandoraPresent(urls)) {
                this.convertArgs(args);
            }
            RunProcess runProcess = new RunProcess(workingDirectory, new String[]{new JavaExecutable().toString()});
            Runtime.getRuntime().addShutdownHook(new Thread(new RunProcessKiller(runProcess)));
            int exitCode = runProcess.run(true, args.toArray(new String[args.size()]));
            if (exitCode == 0 || exitCode == 130) {
                return;
            }
            throw new MojoExecutionException("Application finished with exit code: " + exitCode);
        }
        catch (Exception ex) {
            throw new MojoExecutionException("Could not exec java", ex);
        }
    }

    @Override
    protected void runWithMavenJvm(String startClassName, String ... arguments) throws MojoExecutionException {
        ClassLoader classLoader;
        AbstractRunMojo.IsolatedThreadGroup threadGroup = new AbstractRunMojo.IsolatedThreadGroup(startClassName);
        Thread launchThread = new Thread(threadGroup, (Runnable)new LaunchRunner(startClassName, arguments), "main");
        URL[] urls = this.getClassPathUrls();
        if (this.isPandoraPresent(urls)) {
            try {
                SarLauncher sarLauncher = new SarLauncher();
                classLoader = sarLauncher.createClassLoaderWithParent(urls, ClassLoader.getSystemClassLoader().getParent());
            }
            catch (Exception e) {
                throw new MojoExecutionException("Could not create classloader for SarLauncher", e);
            }
        } else {
            classLoader = new URLClassLoader(urls);
            Health.registMBean();
            SarLoaderUtils.markSarLoaderUtils((ClassLoader)classLoader, (String)"sarLoaded", (Object)true);
        }
        launchThread.setContextClassLoader(classLoader);
        launchThread.start();
        LaunchRunner.join((ThreadGroup)threadGroup);
        threadGroup.rethrowUncaughtException();
    }

    private boolean hasDevtools() {
        if (this.hasDevtools == null) {
            this.hasDevtools = this.checkForDevtools();
        }
        return this.hasDevtools;
    }

    private boolean checkForDevtools() {
        try {
            URL[] urls = this.getClassPathUrls();
            URLClassLoader classLoader = new URLClassLoader(urls);
            return classLoader.findResource(RESTARTER_CLASS_LOCATION) != null;
        }
        catch (Exception ex) {
            return false;
        }
    }

    @Override
    protected URL[] getClassPathUrls() throws MojoExecutionException {
        if (this.classPathUrlsAfterAutoConfig == null) {
            this.classPathUrlsAfterAutoConfig = AutoConfigWrapper.autoConfig((URL[])super.getClassPathUrls());
        }
        return this.classPathUrlsAfterAutoConfig;
    }

    private void convertArgs(List<String> args) {
        int index = args.indexOf(this.getStartClassName());
        if (index > 0) {
            args.add(index, ReLaunchMainLauncher.class.getName());
            args.add(index + 1, "--mainClass");
        }
    }

    private boolean isPandoraPresent(URL[] urls) {
        return this.findPandoraLocation() != null || this.isSarPresentInClassPath(urls);
    }

    private String findPandoraLocation() {
        String externalPandoraLocation = System.getProperty("pandora.location");
        if (externalPandoraLocation == null && this.pandoraLocation != null) {
            System.setProperty("pandora.location", this.pandoraLocation);
            return this.pandoraLocation;
        }
        return externalPandoraLocation;
    }

    private boolean isSarPresentInClassPath(URL[] urls) {
        try {
            return SarLoaderUtils.findFromClassPath((URL[])urls) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static final class RunProcessKiller
    implements Runnable {
        private final RunProcess runProcess;

        private RunProcessKiller(RunProcess runProcess) {
            this.runProcess = runProcess;
        }

        @Override
        public void run() {
            this.runProcess.kill();
        }
    }
}

