/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.pandora.boot.maven;

import com.taobao.pandora.boot.maven.Exclude;
import com.taobao.pandora.boot.maven.ExcludeFilter;
import com.taobao.pandora.boot.maven.Include;
import com.taobao.pandora.boot.maven.IncludeFilter;
import com.taobao.pandora.boot.maven.MatchingGroupIdFilter;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.shared.artifact.filter.collection.ArtifactFilterException;
import org.apache.maven.shared.artifact.filter.collection.ArtifactIdFilter;
import org.apache.maven.shared.artifact.filter.collection.ArtifactsFilter;
import org.apache.maven.shared.artifact.filter.collection.FilterArtifacts;

public abstract class AbstractDependencyFilterMojo
extends AbstractMojo {
    @Parameter
    private List<Include> includes;
    @Parameter
    private List<Exclude> excludes;
    @Parameter(property="excludeGroupIds", defaultValue="")
    private String excludeGroupIds;
    @Parameter(property="excludeArtifactIds", defaultValue="")
    private String excludeArtifactIds;

    protected void setExcludes(List<Exclude> excludes) {
        this.excludes = excludes;
    }

    protected void setIncludes(List<Include> includes) {
        this.includes = includes;
    }

    protected void setExcludeGroupIds(String excludeGroupIds) {
        this.excludeGroupIds = excludeGroupIds;
    }

    protected void setExcludeArtifactIds(String excludeArtifactIds) {
        this.excludeArtifactIds = excludeArtifactIds;
    }

    protected Set<Artifact> filterDependencies(Set<Artifact> dependencies, FilterArtifacts filters) throws MojoExecutionException {
        try {
            LinkedHashSet<Artifact> filtered = new LinkedHashSet<Artifact>(dependencies);
            filtered.retainAll(filters.filter(dependencies));
            LinkedHashSet<Artifact> discarded = new LinkedHashSet<Artifact>(dependencies);
            discarded.removeAll(filtered);
            for (Artifact artifact : discarded) {
                this.getLog().debug((CharSequence)("Discarded dependency: " + artifact.getId()));
            }
            return filtered;
        }
        catch (ArtifactFilterException ex) {
            throw new MojoExecutionException(ex.getMessage(), (Exception)((Object)ex));
        }
    }

    protected final FilterArtifacts getFilters(ArtifactsFilter ... additionalFilters) {
        FilterArtifacts filters = new FilterArtifacts();
        for (ArtifactsFilter additionalFilter : additionalFilters) {
            filters.addFilter(additionalFilter);
        }
        filters.addFilter((ArtifactsFilter)new ArtifactIdFilter("", this.cleanFilterConfig(this.excludeArtifactIds)));
        filters.addFilter((ArtifactsFilter)new MatchingGroupIdFilter(this.cleanFilterConfig(this.excludeGroupIds)));
        if (this.includes != null && !this.includes.isEmpty()) {
            filters.addFilter((ArtifactsFilter)new IncludeFilter(this.includes));
        }
        if (this.excludes != null && !this.excludes.isEmpty()) {
            filters.addFilter((ArtifactsFilter)new ExcludeFilter(this.excludes));
        }
        return filters;
    }

    private String cleanFilterConfig(String content) {
        if (content == null || content.trim().isEmpty()) {
            return "";
        }
        StringBuilder cleaned = new StringBuilder();
        StringTokenizer tokenizer = new StringTokenizer(content, ",");
        while (tokenizer.hasMoreElements()) {
            cleaned.append(tokenizer.nextToken().trim());
            if (!tokenizer.hasMoreElements()) continue;
            cleaned.append(",");
        }
        return cleaned.toString();
    }
}

