/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.pandora.boot.logconfig;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import org.slf4j.LoggerFactory;

public abstract class LogConfigurator {
    private static final String PROVIDERS_PATTERN = "META-INF/pandoraboot/logconfig.providers";
    private static final String LOGGING_LEVEL = "loggingLevel";
    private static final String LOGGING_CHARSET = "loggingCharset";
    private static final String LOGGING_ROOT = "loggingRoot";
    private static final String LOCAL_HOST = "localHost";
    private static final String LOCAL_ADDRESS = "localAddress";
    private String logSystem;

    public final void configure(URL configFile) {
        this.configure(configFile, null);
    }

    public final void configure(URL configFile, Map<String, String> props) {
        StringBuilder buf = new StringBuilder();
        buf.append("INFO: configuring \"").append(this.logSystem).append("\" using ").append(configFile).append("\n");
        if (props == null) {
            props = new HashMap<String, String>();
        }
        for (String key : new TreeSet<String>(props.keySet())) {
            String value = props.get(key);
            if (!key.startsWith("log") && (value == null || value.equals(System.getProperty(key)))) continue;
            buf.append(" - with property ").append(key).append(" = ").append(value).append("\n");
        }
        LogConfigurator.log(buf.toString());
        try {
            this.doConfigure(configFile, props);
        }
        catch (Exception e) {
            LogConfigurator.log("WARN: Failed to configure " + this.logSystem + " using " + configFile, e);
        }
    }

    public final void configureDefault() {
        this.configureDefault(null);
    }

    public final void configureDefault(Boolean debug) {
        URL configFile = this.getDefaultConfigFile();
        if (configFile == null) {
            LogConfigurator.log("ERROR: could not find default config file for \"" + this.logSystem + "\"");
            return;
        }
        this.configure(configFile, this.getDefaultProperties(debug));
    }

    public final String getLogSystem() {
        return this.logSystem;
    }

    public final URL getDefaultConfigFile() {
        return this.getClass().getClassLoader().getResource(this.getClass().getPackage().getName().replace('.', '/') + "/" + this.getDefaultConfigFileName());
    }

    protected String getDefaultConfigFileName() {
        return this.logSystem + "-default.xml";
    }

    public final Map<String, String> getDefaultProperties() {
        return this.getDefaultProperties(null);
    }

    public final Map<String, String> getDefaultProperties(Boolean debug) {
        String hostAddress;
        String hostName;
        HashMap<String, String> props = new HashMap<String, String>();
        Properties systemProperties = System.getProperties();
        for (String key : systemProperties.stringPropertyNames()) {
            props.put(key, String.valueOf(systemProperties.get(key)));
        }
        if (!this.isPropertyExist(props, LOGGING_CHARSET)) {
            props.put(LOGGING_CHARSET, this.getDefaultCharset());
        }
        if (!this.isPropertyExist(props, LOGGING_LEVEL)) {
            if (debug == null) {
                debug = false;
            }
            props.put(LOGGING_LEVEL, this.getDefaultLevel(debug));
        }
        if (!this.isPropertyExist(props, LOGGING_ROOT)) {
            props.put(LOGGING_ROOT, this.getDefaultLoggingRoot());
        }
        try {
            InetAddress localhost = InetAddress.getLocalHost();
            hostName = localhost.getHostName();
            hostAddress = localhost.getHostAddress();
        }
        catch (UnknownHostException e) {
            hostName = "localhost";
            hostAddress = "127.0.0.1";
        }
        props.put(LOCAL_HOST, hostName);
        props.put(LOCAL_ADDRESS, hostAddress);
        this.setDefaultProperties(props);
        return props;
    }

    private boolean isPropertyExist(Map<String, String> props, String name) {
        return LogConfigurator.trimToNull(props.get(name)) != null;
    }

    private String getDefaultCharset() {
        return Charset.defaultCharset().name();
    }

    private String getDefaultLevel(boolean debug) {
        return debug ? "TRACE" : "INFO";
    }

    private String getDefaultLoggingRoot() {
        return new File(System.getProperty("user.home") + "/logs").getAbsolutePath();
    }

    protected void setDefaultProperties(Map<String, String> props) {
    }

    protected abstract void doConfigure(URL var1, Map<String, String> var2) throws Exception;

    public abstract void shutdown();

    public static LogConfigurator getConfigurator() {
        return LogConfigurator.getConfigurator(null);
    }

    public static LogConfigurator getConfigurator(String logSystem) {
        LogConfigurator[] configurators = LogConfigurator.getConfigurators(logSystem);
        if (configurators == null || configurators.length == 0) {
            return null;
        }
        return configurators[0];
    }

    public static LogConfigurator[] getConfigurators(String ... logSystems) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Map<String, String> providers = LogConfigurator.getProviders(PROVIDERS_PATTERN, cl);
        String slf4jLogSystem = LogConfigurator.guessSlf4jLogSystem(providers);
        LinkedHashSet<String> logSystemToBeConfigured = new LinkedHashSet<String>();
        if (logSystems == null || logSystems.length == 0) {
            logSystems = new String[1];
        }
        boolean containsNull = false;
        for (String logSystem : logSystems) {
            if (logSystem != null) {
                logSystem = LogConfigurator.trimToNull(logSystem.toLowerCase());
            }
            if (logSystem == null) {
                logSystem = slf4jLogSystem;
            }
            if (logSystem == null) {
                containsNull = true;
                continue;
            }
            logSystemToBeConfigured.add(logSystem);
        }
        if (slf4jLogSystem != null && !logSystemToBeConfigured.contains(slf4jLogSystem)) {
            LogConfigurator.log("WARN: The current logging system [" + slf4jLogSystem + "] used by SLF4J may not be configured, " + "because it is not in the configuration list: " + logSystemToBeConfigured + ".");
        }
        if (containsNull) {
            LogConfigurator.log("WARN: No log system bound with SLF4J");
        }
        LogConfigurator[] configurators = new LogConfigurator[logSystemToBeConfigured.size()];
        int i = 0;
        for (String logSystem : logSystemToBeConfigured) {
            LogConfigurator configurator;
            Class<?> providerClass;
            String providerClassName = providers.get(logSystem);
            if (providerClassName == null) {
                throw new IllegalArgumentException("Could not find LogConfigurator for \"" + logSystem + "\" by searching in " + PROVIDERS_PATTERN);
            }
            try {
                providerClass = cl.loadClass(providerClassName);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Could not find LogConfigurator for " + logSystem, e);
            }
            if (!LogConfigurator.class.isAssignableFrom(providerClass)) {
                throw new IllegalArgumentException(logSystem + " class " + providerClassName + " is not a sub-class of " + LogConfigurator.class.getName());
            }
            try {
                configurator = (LogConfigurator)providerClass.newInstance();
            }
            catch (Throwable e) {
                throw new IllegalArgumentException("Could not create instance of class " + providerClassName + " for " + logSystem, e);
            }
            configurator.logSystem = logSystem;
            configurators[i++] = configurator;
        }
        return configurators;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, String> getProviders(String location, ClassLoader cl) {
        Properties props = new Properties();
        Enumeration<URL> i = null;
        try {
            i = cl.getResources(location);
        }
        catch (IOException e) {
            LogConfigurator.log("ERROR: Failed to read " + location, e);
        }
        while (i != null && i.hasMoreElements()) {
            URL url = i.nextElement();
            InputStream is = null;
            try {
                is = url.openStream();
                props.load(is);
            }
            catch (Exception e) {
                LogConfigurator.log("ERROR: Failed to read " + url, e);
            }
            finally {
                if (is == null) continue;
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
        HashMap<String, String> propsMap = new HashMap<String, String>();
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            String key = LogConfigurator.trimToNull(entry.getKey());
            String className = LogConfigurator.trimToNull(entry.getValue());
            if (key == null || className == null) continue;
            propsMap.put(key.toLowerCase(), className);
        }
        return propsMap;
    }

    private static String guessSlf4jLogSystem(Map<String, String> providers) {
        String s;
        try {
            s = LoggerFactory.getILoggerFactory().getClass().getName().toLowerCase();
        }
        catch (Throwable e) {
            s = null;
        }
        if (s != null) {
            for (String name : providers.keySet()) {
                if (!s.contains(name)) continue;
                return name;
            }
        }
        return null;
    }

    protected static String trimToNull(Object str) {
        if (!(str instanceof String)) {
            return null;
        }
        String result = ((String)str).trim();
        if (result == null || result.length() == 0) {
            return null;
        }
        return result;
    }

    protected static void log(String msg) {
        LogConfigurator.log("[Pandora Boot] " + msg, null);
    }

    protected static void log(String msg, Throwable e) {
        System.out.flush();
        System.err.println(msg);
        if (e != null) {
            e.printStackTrace();
        }
        System.err.flush();
    }
}

