/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.pandora.boot.common.utils;

import java.util.List;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.expression.AccessException;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.TypedValue;
import org.springframework.expression.spel.support.ReflectivePropertyAccessor;
import org.springframework.expression.spel.support.StandardEvaluationContext;

public class BeanDefinitionBuilderUtils {
    public static void addFieldsFromGetterMethod(BeanDefinitionBuilder builder, Object object, List<String> fields) {
        StandardEvaluationContext evaluationContext = new StandardEvaluationContext();
        ReflectivePropertyAccessor accessor = new ReflectivePropertyAccessor();
        for (String field : fields) {
            TypedValue typedValue = null;
            try {
                typedValue = accessor.read((EvaluationContext)evaluationContext, object, field);
            }
            catch (AccessException e) {
                throw new IllegalArgumentException(String.format("Try to read field: %s from %s fail.", field, object.getClass().getName()), e);
            }
            Object value = typedValue.getValue();
            if (value == null) continue;
            builder.addPropertyValue(field, typedValue.getValue());
        }
    }
}

