/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.pandora.boot.spring;

import com.taobao.pandora.boot.common.utils.AnsiLog;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.annotation.PostConstruct;
import org.springframework.boot.actuate.autoconfigure.EndpointAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;

@Configuration
@ConditionalOnClass(value={EndpointAutoConfiguration.class})
@ConditionalOnProperty(name={"spring.loggerConflictDetector.enabled"}, havingValue="true", matchIfMissing=true)
@Order(value=-2147483648)
public class LoggerConflictDetector {
    @PostConstruct
    public void init() throws IOException {
        ClassLoader classLoader = LoggerConflictDetector.class.getClassLoader();
        List<URL> log4jProperties = LoggerConflictDetector.toList(classLoader.getResources("log4j.properties"));
        LoggerConflictDetector.checkMultiConfigFiles("log4j", log4jProperties);
        List<URL> log4jXmls = LoggerConflictDetector.toList(classLoader.getResources("log4j.xml"));
        LoggerConflictDetector.checkMultiConfigFiles("log4j", log4jXmls);
        List<URL> logbackXmls = LoggerConflictDetector.toList(classLoader.getResources("logback.xml"));
        LoggerConflictDetector.checkMultiConfigFiles("logback", logbackXmls);
        List<URL> logbackSpringXmls = LoggerConflictDetector.toList(classLoader.getResources("logback-spring.xml"));
        LoggerConflictDetector.checkMultiConfigFiles("logback", logbackSpringXmls);
        if (logbackSpringXmls.size() >= 1 && logbackXmls.size() >= 1) {
            AnsiLog.error((String)"[LoggerConflictDetector] both found logback.xml and logback-spring.xml in classpath. In spring boot application, please keep logback-spring.xml only.");
            for (URL url : logbackXmls) {
                AnsiLog.error((String)("[LoggerConflictDetector] found: " + url));
            }
            for (URL url : logbackSpringXmls) {
                AnsiLog.error((String)("[LoggerConflictDetector] found: " + url));
            }
        }
    }

    private static void checkMultiConfigFiles(String loggerSystem, List<URL> resources) {
        if (resources.size() > 1) {
            AnsiLog.error((String)"[LoggerConflictDetector] found {} has more than one config files.", (Object[])new Object[]{loggerSystem});
            for (URL url : resources) {
                AnsiLog.error((String)("[LoggerConflictDetector] found: " + url));
            }
        }
    }

    private static <T> List<T> toList(Enumeration<T> resources) {
        ArrayList<T> result = new ArrayList<T>();
        if (resources != null) {
            while (resources.hasMoreElements()) {
                result.add(resources.nextElement());
            }
        }
        return result;
    }
}

