/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.pandora.boot;

import com.taobao.pandora.boot.AutoConfigWrapper;
import com.taobao.pandora.boot.common.utils.AnsiLog;
import com.taobao.pandora.boot.common.utils.VersionUtils;
import com.taobao.pandora.boot.loader.ReLaunchMainLauncher;
import com.taobao.pandora.boot.loader.SarLoaderUtils;
import com.taobao.pandora.boot.loader.jmx.mbean.Health;
import com.taobao.pandora.boot.loader.util.ClassLoaderUtils;
import com.taobao.pandora.boot.logconfig.LogConfigUtil;
import java.net.URL;

public class PandoraBootstrap {
    public static void run(String[] args) {
        if (PandoraBootstrap.argsConatinPandoraLocation(args)) {
            AnsiLog.error((String)"[ERROR] Please don't set -Dpandora.location in Program arguments, set in VM arguments. Google 'Program arguments VM arguments'.");
        }
        VersionUtils.setPandoraBootStarterVersionSystemProperty();
        if (SarLoaderUtils.unneedLoadSar()) {
            LogConfigUtil.initLoggingSystem();
            return;
        }
        URL[] urls = ClassLoaderUtils.getUrls((ClassLoader)PandoraBootstrap.class.getClassLoader());
        if (urls == null) {
            throw new IllegalStateException("Can not find urls from the ClassLoader of PandoraBootstrap. ClassLoader: " + PandoraBootstrap.class.getClassLoader());
        }
        urls = AutoConfigWrapper.autoConfig((URL[])urls);
        ReLaunchMainLauncher.launch((String[])args, (String)PandoraBootstrap.deduceMainApplicationClass().getName(), (URL[])urls);
    }

    private static boolean argsConatinPandoraLocation(String[] args) {
        if (args != null) {
            for (String arg : args) {
                if (!arg.contains("-Dpandora.location")) continue;
                return true;
            }
        }
        return false;
    }

    public static void markStartupAndWait() {
        long t1 = SarLoaderUtils.t1();
        long t2 = System.nanoTime();
        AnsiLog.info((String)("Service(pandora boot) startup in " + (t2 - t1) / 1000000L + " ms"));
        Health.markStartup();
        if ("true".equalsIgnoreCase(System.getProperty("pandora.boot.wait", "true"))) {
            try {
                Health.markAwait();
                AnsiLog.info((String)"Service(pandora boot) receive shutdown command, ready to shutdown...");
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        LogConfigUtil.destoryLoggingSystem();
    }

    private static Class<?> deduceMainApplicationClass() {
        try {
            StackTraceElement[] stackTrace;
            for (StackTraceElement stackTraceElement : stackTrace = new RuntimeException().getStackTrace()) {
                if (!"main".equals(stackTraceElement.getMethodName())) continue;
                return Class.forName(stackTraceElement.getClassName());
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return null;
    }
}

