/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.pandora.boot;

import com.taobao.pandora.boot.AutoConfigWrapper;
import com.taobao.pandora.boot.common.utils.VersionUtils;
import com.taobao.pandora.boot.loader.InputArgumentsJavaAgentDetector;
import com.taobao.pandora.boot.loader.LaunchRunner;
import com.taobao.pandora.boot.loader.LaunchedURLClassLoader;
import com.taobao.pandora.boot.loader.SarLoaderUtils;
import com.taobao.pandora.boot.loader.jmx.mbean.Health;
import com.taobao.pandora.boot.loader.util.SystemPrintUtil;
import com.taobao.pandora.boot.logconfig.LogConfigUtil;
import com.taobao.pandora.loader.archive.Archive;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Map;

public class PandoraBootstrap {
    public static void run(String[] args) {
        if (PandoraBootstrap.argsConatinPandoraLocation(args)) {
            System.err.println("[ERROR] Please don't set -Dpandora.location in Program arguments, set in VM arguments. Google 'Program arguments VM arguments'.");
        }
        VersionUtils.setPandoraBootStarterVersionSystemProperty();
        if (SarLoaderUtils.unneedLoadSar()) {
            LogConfigUtil.initLoggingSystem();
            return;
        }
        long t1 = System.nanoTime();
        Health.registMBean();
        SystemPrintUtil.switchSystemPrint();
        String mainClass = PandoraBootstrap.deduceMainApplicationClass().getName();
        URLClassLoader classLoader = (URLClassLoader)PandoraBootstrap.class.getClassLoader();
        URL[] urls = classLoader.getURLs();
        urls = AutoConfigWrapper.autoConfig((URL[])urls);
        LaunchedURLClassLoader reLaunchClassLoader = new LaunchedURLClassLoader(PandoraBootstrap.cleanJavaAgentUrls(urls), ClassLoader.getSystemClassLoader());
        try {
            Archive sar = SarLoaderUtils.findExternalSar();
            if (sar == null && (sar = SarLoaderUtils.findFromClassPath((URL[])urls)) == null) {
                if ("true".equalsIgnoreCase(System.getProperty("pandora.boot.failFast"))) {
                    throw new RuntimeException("can not load taobao-hsf.sar, please check your config!");
                }
                System.err.println("Can not load taobao-hsf.sar! If you do not use taobao-hsf.sar, ignore this. Otherwise please check '-Dpandora.location=' or maven dependencies if there contains taobao-hsf.sar!");
            }
            if (sar != null) {
                Map classCache = SarLoaderUtils.getClassCache((Archive)sar, (ClassLoader)reLaunchClassLoader);
                reLaunchClassLoader.setClassCache(classCache);
            }
            SarLoaderUtils.markSarLoaderUtils((ClassLoader)reLaunchClassLoader, (String)"sarLoaded", (Object)true);
            SarLoaderUtils.markSarLoaderUtils((ClassLoader)reLaunchClassLoader, (String)"t1", (Object)t1);
        }
        catch (Exception e) {
            throw new RuntimeException("load pandora error!", e);
        }
        PandoraBootstrap.reLaunch(args, mainClass, (ClassLoader)reLaunchClassLoader);
        System.exit(0);
    }

    private static boolean argsConatinPandoraLocation(String[] args) {
        if (args != null) {
            for (String arg : args) {
                if (!arg.contains("-Dpandora.location")) continue;
                return true;
            }
        }
        return false;
    }

    private static URL[] cleanJavaAgentUrls(URL[] urls) {
        InputArgumentsJavaAgentDetector javaAgentDetector = new InputArgumentsJavaAgentDetector();
        ArrayList<URL> result = new ArrayList<URL>(urls.length);
        for (URL url : urls) {
            if (javaAgentDetector.isJavaAgentJar(url)) continue;
            result.add(url);
        }
        return result.toArray(new URL[0]);
    }

    public static void markStartupAndWait() {
        long t1 = SarLoaderUtils.t1();
        long t2 = System.nanoTime();
        System.out.println("Service(pandora boot) startup in " + (t2 - t1) / 1000000L + " ms");
        Health.markStartup();
        if ("true".equalsIgnoreCase(System.getProperty("pandora.boot.wait", "true"))) {
            try {
                Health.markAwait();
                System.out.println("Service(pandora boot) receive shutdown command, ready to shutdown...");
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        LogConfigUtil.destoryLoggingSystem();
    }

    private static void reLaunch(String[] args, String mainClass, ClassLoader classLoader) {
        IsolatedThreadGroup threadGroup = new IsolatedThreadGroup(mainClass);
        Thread launchThread = new Thread(threadGroup, (Runnable)new LaunchRunner(mainClass, args), "main");
        launchThread.setContextClassLoader(classLoader);
        launchThread.start();
        LaunchRunner.join((ThreadGroup)threadGroup);
        threadGroup.rethrowUncaughtException();
    }

    private static Class<?> deduceMainApplicationClass() {
        try {
            StackTraceElement[] stackTrace;
            for (StackTraceElement stackTraceElement : stackTrace = new RuntimeException().getStackTrace()) {
                if (!"main".equals(stackTraceElement.getMethodName())) continue;
                return Class.forName(stackTraceElement.getClassName());
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return null;
    }

    static class IsolatedThreadGroup
    extends ThreadGroup {
        private Throwable exception;

        IsolatedThreadGroup(String name) {
            super(name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void uncaughtException(Thread thread, Throwable ex) {
            if (!(ex instanceof ThreadDeath)) {
                IsolatedThreadGroup isolatedThreadGroup = this;
                synchronized (isolatedThreadGroup) {
                    this.exception = this.exception == null ? ex : this.exception;
                }
                ex.printStackTrace();
            }
        }

        public synchronized void rethrowUncaughtException() throws RuntimeException {
            if (this.exception != null) {
                throw new RuntimeException("An exception occured while running. " + this.exception.getMessage(), this.exception);
            }
        }
    }
}

