/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.pandora.boot.spring.classloader;

import com.taobao.pandora.boot.loader.ClassLoaderInspector;
import com.taobao.pandora.boot.spring.ClassLoaderInfoUtils;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.boot.actuate.endpoint.mvc.AbstractMvcEndpoint;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@ConfigurationProperties(value="endpoints.classloader")
public class ClassLoaderEndPoint
extends AbstractMvcEndpoint {
    public ClassLoaderEndPoint() {
        super("/classloader", false);
    }

    @RequestMapping
    @ResponseBody
    public Map<String, Object> invoke() {
        return ClassLoaderInfoUtils.info();
    }

    @RequestMapping(value={"system"})
    @ResponseBody
    public Map<String, Object> systemClassLoader() {
        return ClassLoaderInfoUtils.systemClassLoader();
    }

    @RequestMapping(value={"getResource"})
    @ResponseBody
    public String getResource(@RequestParam(value="name") String name) {
        return ClassLoaderInfoUtils.getResource((String)name);
    }

    @RequestMapping(value={"getResources"})
    @ResponseBody
    public List<String> getResources(@RequestParam(value="name") String name) throws IOException {
        return ClassLoaderInfoUtils.getResources((String)name);
    }

    @RequestMapping(value={"getClass"})
    @ResponseBody
    public Map<String, Object> getClass(@RequestParam(value="name") String name) throws ClassNotFoundException {
        return ClassLoaderInfoUtils.getClass((String)name);
    }

    @RequestMapping(value={"classNotFound"})
    @ResponseBody
    public Set<String> classNotFound() {
        return ClassLoaderInspector.getClassNotFoundList();
    }
}

