/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.pandora.boot.spring.analyzer;

import java.net.URL;
import java.security.CodeSource;
import org.springframework.boot.diagnostics.FailureAnalysis;
import org.springframework.boot.diagnostics.analyzer.AbstractInjectionFailureAnalyzer;
import org.springframework.context.ApplicationContextException;

public class IncompatibleServletFailureAnalyzer
extends AbstractInjectionFailureAnalyzer<ApplicationContextException> {
    protected FailureAnalysis analyze(Throwable rootFailure, ApplicationContextException cause, String description) {
        URL location;
        String message = cause.getMessage();
        if (message != null && message.contains("Unable to start embedded Tomcat") && (location = IncompatibleServletFailureAnalyzer.findClassLocation("javax.servlet.ServletContext")) != null && !location.toString().contains("tomcat-embed-core")) {
            return new FailureAnalysis("The servlet-api classes is incompatible, location: " + location, "Exclude the incompatible servlet-api dependency.", (Throwable)cause);
        }
        return null;
    }

    private static URL findClassLocation(String className) {
        try {
            Class<?> clazz = Class.forName(className);
            CodeSource codeSource = clazz.getProtectionDomain().getCodeSource();
            if (codeSource != null) {
                return codeSource.getLocation();
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return null;
    }
}

