/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.pandora.boot.autoconf;

import com.alibaba.antx.config.ConfigRuntimeImpl;
import com.alibaba.antx.util.SelectorUtil;
import com.alibaba.citrus.logconfig.LogConfigurator;
import com.taobao.pandora.boot.autoconf.Constants;
import com.taobao.pandora.boot.autoconf.DirUrlTransformer;
import com.taobao.pandora.boot.autoconf.JarUrlTransformer;
import com.taobao.pandora.boot.autoconf.UrlTransformer;
import com.taobao.pandora.boot.utils.FileUtils;
import com.taobao.pandora.boot.utils.UrlUtils;
import java.io.File;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;

public class AutoConfigure {
    /*
     * WARNING - void declaration
     */
    public URL[] config(URL[] urls) {
        void var7_9;
        if (urls == null || urls.length == 0) {
            return urls;
        }
        if (Boolean.parseBoolean(System.getProperty("autoconfig.clean.metaInf", "true"))) {
            AutoConfigure.cleanMetaInf(urls);
        }
        File tempDir = FileUtils.createTempDir("autoconf", "lib");
        tempDir.deleteOnExit();
        UrlTransformer[] urlTransformers = new UrlTransformer[]{new DirUrlTransformer(tempDir), new JarUrlTransformer(tempDir)};
        ArrayList<void> transformedUrls = new ArrayList<void>();
        URL[] uRLArray = urls;
        int n = uRLArray.length;
        boolean bl = false;
        while (var7_9 < n) {
            void var8_12;
            URL uRL = uRLArray[var7_9];
            UrlTransformer[] urlTransformerArray = urlTransformers;
            int n2 = urlTransformerArray.length;
            for (int i = 0; i < n2; ++i) {
                UrlTransformer urlTransformer = urlTransformerArray[i];
                URL uRL2 = urlTransformer.map((URL)var8_12);
            }
            transformedUrls.add(var8_12);
            ++var7_9;
        }
        ArrayList<String> destinations = new ArrayList<String>();
        block2: for (URL uRL : transformedUrls) {
            for (UrlTransformer urlTransformer : urlTransformers) {
                if (!urlTransformer.filter(uRL)) continue;
                destinations.add(UrlUtils.toFile(uRL).getPath());
                continue block2;
            }
        }
        String charset = System.getProperty("autoconfig.charset");
        if (destinations.size() > 0) {
            void var8_19;
            System.out.println("Jar files which may need autoconfig are saving to " + tempDir);
            ConfigRuntimeImpl configRuntimeImpl = new ConfigRuntimeImpl(System.in, (OutputStream)System.out, (OutputStream)System.err, charset);
            configRuntimeImpl.setInteractiveMode("auto");
            String string = System.getProperty("autoconfig.userProperties");
            if (string == null) {
                String string2 = System.getProperty("antx.properties");
            }
            if (var8_19 != null) {
                configRuntimeImpl.setUserPropertiesFile((String)var8_19, charset);
                System.out.println("Using autoconfig userPropertiees file: " + (String)var8_19);
            } else {
                System.out.println("[AutoConfig] Use -Dautoconfig.userProperties= to set specified antx.properties.");
            }
            LogConfigurator logConfigurator = LogConfigurator.getConfigurator();
            logConfigurator.configureDefault(false, charset);
            configRuntimeImpl.setDests(destinations.toArray(new String[destinations.size()]));
            configRuntimeImpl.start();
        }
        return transformedUrls.toArray(new URL[transformedUrls.size()]);
    }

    private static void cleanMetaInf(URL[] urls) {
        for (URL url : urls) {
            if (!"file".equals(url.getProtocol())) continue;
            try {
                File autoConfDir;
                File file = new File(url.toURI().getSchemeSpecificPart());
                if (!file.isDirectory() || !file.getAbsolutePath().endsWith("/target/classes") || !(autoConfDir = new File(file, "META-INF/autoconf")).isDirectory()) continue;
                AutoConfigure.deleteAutoConfMetaInfDirectory(file, autoConfDir);
                System.out.println("[AutoConfig] clean " + autoConfDir.getAbsolutePath());
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
        }
    }

    private static void deleteAutoConfMetaInfDirectory(File baseDirectory, File directory) {
        File[] files;
        if (directory.isDirectory() && (files = directory.listFiles()) != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    AutoConfigure.deleteAutoConfMetaInfDirectory(baseDirectory, file);
                    continue;
                }
                if (AutoConfigure.mathcConfigFile(baseDirectory, file)) continue;
                file.delete();
            }
        }
    }

    private static boolean mathcConfigFile(File dir, File file) {
        try {
            String fileUrlStr = file.toURI().toURL().toString();
            String dirUrlStr = dir.toURI().toURL().toString();
            String path = fileUrlStr.substring(dirUrlStr.length());
            return SelectorUtil.matchPath((String)path, (String[])Constants.CONFIG_XML_PATTERNS, (String[])new String[0]);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return false;
        }
    }
}

