/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.illidan.services.http.jsonrpc;

import com.taobao.illidan.common.utils.StandardCharsets;
import com.taobao.illidan.common.utils.io.IOUtils;
import com.taobao.illidan.common.utils.json.DecodeException;
import com.taobao.illidan.common.utils.json.JsonArray;
import com.taobao.illidan.common.utils.json.JsonMarshaller;
import com.taobao.illidan.common.utils.json.JsonMarshallerFactory;
import com.taobao.illidan.common.utils.json.JsonObject;
import com.taobao.illidan.common.utils.logging.InternalLogger;
import com.taobao.illidan.common.utils.logging.InternalLoggerFactory;
import com.taobao.illidan.core.Function;
import com.taobao.illidan.core.Predicate;
import com.taobao.illidan.services.core.Invokable;
import com.taobao.illidan.services.http.extender.EmbeddedExtender;
import com.taobao.illidan.services.http.extender.ExtendedHandler;
import com.taobao.illidan.services.http.jsonrpc.JsonError;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.HeaderValues;
import io.undertow.util.HttpString;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class JsonRpcHttpHandler
implements HttpHandler {
    private static final InternalLogger LOGGER = InternalLoggerFactory.getInstance(JsonRpcHttpHandler.class);
    private static final HttpString CONTENT_TYPE_HEADER_NAME = new HttpString("Content-Type");
    private JsonMarshaller marshaller = JsonMarshallerFactory.factory.getInstance();
    protected final String path;
    private final Map<String, String[]> locationInfos;
    private final Invokable invokable;
    private final List<ExtendedHandler> embeddedExtenders = new ArrayList<ExtendedHandler>();

    public JsonRpcHttpHandler(String path, Invokable invokable, Map<String, String[]> locationInfos) {
        this.invokable = invokable;
        this.path = path;
        this.locationInfos = locationInfos;
        ExtendedHandler.Helper.runAll(new Predicate<ExtendedHandler>(){

            public boolean test(ExtendedHandler t) {
                return t.getClass().isAnnotationPresent(EmbeddedExtender.class);
            }
        }, new Function<ExtendedHandler, Object>(){

            public Object apply(ExtendedHandler t) {
                JsonRpcHttpHandler.this.embeddedExtenders.add(t);
                return null;
            }
        });
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        Object[] args = null;
        if (exchange.isInIoThread()) {
            exchange.dispatch((HttpHandler)this);
            return;
        }
        exchange.startBlocking();
        this.executeEmbeddedExtenders(exchange);
        JsonObject jsonReqeust = this.parseJsonRequest(exchange);
        Object id = null;
        try {
            id = jsonReqeust.getString("id");
        }
        catch (Exception e) {
            id = jsonReqeust.getInteger("id");
        }
        try {
            args = this.parseArguments(jsonReqeust);
        }
        catch (Exception e1) {
            this.send(exchange, this.createJsonResponse(id, null, JsonError.PARSE_ERROR));
            LOGGER.error("parse argument failed. handler is " + this, (Throwable)e1);
            return;
        }
        JsonObject jsonResponse = this.invoke(id, jsonReqeust.getString("method"), args);
        this.send(exchange, jsonResponse);
    }

    private JsonObject parseJsonRequest(HttpServerExchange exchange) throws IOException, DecodeException {
        InputStream i = exchange.getInputStream();
        HeaderValues contentType = exchange.getRequestHeaders().get("Content-Encoding");
        String input = IOUtils.toString((InputStream)i, (String)(null == contentType || contentType.isEmpty() ? StandardCharsets.UTF_8.name() : contentType.getFirst()));
        return new JsonObject(input);
    }

    private Object[] parseArguments(JsonObject jsonRequest) throws Exception {
        Object[] args = null;
        try {
            String method = jsonRequest.getString("method");
            String[] infos = this.locationInfos.get(method);
            if (null == infos || 0 == infos.length) {
                return null;
            }
            args = new Object[infos.length];
            List realParams = null;
            Object params = jsonRequest.getValue("params");
            realParams = params instanceof JsonArray ? ((JsonArray)params).getList() : Collections.singletonList(params);
            for (int i = 0; i < infos.length; ++i) {
                Object param = realParams.get(i);
                if (null == param) continue;
                String className = infos[i];
                Object result = JsonRpcHttpHandler.valueFromString(className, param);
                if (null != result) {
                    args[i] = result;
                    continue;
                }
                JsonObject j = null;
                j = param instanceof JsonObject ? (JsonObject)param : (param instanceof Map ? new JsonObject((Map)param) : new JsonObject(String.valueOf(param)));
                args[i] = this.marshaller.decodeValue(j.encode(), Class.forName(className));
            }
        }
        catch (DecodeException e) {
            LOGGER.error("fail to decode value from POST body", (Throwable)e);
            throw e;
        }
        return args;
    }

    private JsonObject invoke(Object id, String method, Object[] args) {
        Object result = null;
        try {
            result = this.invokable.call(method, args);
        }
        catch (Exception e) {
            LOGGER.error("invoke target failed.id is " + id + " , method is " + method + " , args is " + Arrays.toString(args), (Throwable)e);
            return this.createJsonResponse(id, result, JsonError.createInvokeError(e.getMessage()));
        }
        return this.createJsonResponse(id, result, null);
    }

    private JsonObject createJsonResponse(Object id, Object result, JsonError error) {
        JsonObject jsonResponse = new JsonObject();
        if (null != id) {
            jsonResponse.put("id", id);
        }
        jsonResponse.put("jsonrpc", "2.0");
        if (null != error) {
            jsonResponse.put("error", (Object)error);
        } else {
            jsonResponse.put("result", result);
        }
        return jsonResponse;
    }

    private void send(HttpServerExchange exchange, JsonObject jsonResponse) {
        exchange.getResponseHeaders().add(CONTENT_TYPE_HEADER_NAME, "application/json");
        exchange.getResponseSender().send(jsonResponse.toString());
    }

    private void executeEmbeddedExtenders(HttpServerExchange exchange) {
        for (ExtendedHandler handler : this.embeddedExtenders) {
            handler.handleRequest(exchange);
        }
    }

    private static Object valueFromString(String classString, Object value) {
        if (null == value) {
            return null;
        }
        if ("int".equals(classString) || "java.lang.Integer".equals(classString)) {
            return Integer.valueOf(String.valueOf(value));
        }
        if ("long".equals(classString) || "java.lang.Long".equals(classString)) {
            return Long.valueOf(String.valueOf(value));
        }
        if ("double".equals(classString) || "java.lang.Double".equals(classString)) {
            return Double.valueOf(String.valueOf(value));
        }
        if ("float".equals(classString) || "java.lang.Float".equals(classString)) {
            return Float.valueOf(String.valueOf(value));
        }
        if ("short".equals(classString) || "java.lang.Short".equals(classString)) {
            return Short.valueOf(String.valueOf(value));
        }
        if ("boolean".equals(classString) || "java.lang.Boolean".equals(classString)) {
            return Boolean.valueOf(String.valueOf(value));
        }
        if ("java.lang.String".equals(classString)) {
            return value;
        }
        return null;
    }
}

