/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.illidan.services.http.injector;

import com.taobao.illidan.common.utils.identify.Identifiable;
import com.taobao.illidan.services.http.annotation.spring.DeleteMapping;
import com.taobao.illidan.services.http.annotation.spring.GetMapping;
import com.taobao.illidan.services.http.annotation.spring.PathVariable;
import com.taobao.illidan.services.http.annotation.spring.PostMapping;
import com.taobao.illidan.services.http.annotation.spring.PutMapping;
import com.taobao.illidan.services.http.annotation.spring.RequestBody;
import com.taobao.illidan.services.http.annotation.spring.RequestMapping;
import com.taobao.illidan.services.http.annotation.spring.RequestMethod;
import com.taobao.illidan.services.http.annotation.spring.RequestParam;
import com.taobao.illidan.services.http.constants.HttpMethod;
import com.taobao.illidan.services.http.domain.HttpMetadata;
import com.taobao.illidan.services.http.domain.ParamInfo;
import com.taobao.illidan.services.http.domain.PathInfo;
import com.taobao.illidan.services.http.domain.ServiceParamType;
import com.taobao.illidan.services.http.injector.AbstractAnnotationHttpInfoInjector;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.Map;

@Identifiable(value="http:springAnnotation")
public class SpringHttpInfoInjector
extends AbstractAnnotationHttpInfoInjector {
    @Override
    protected Map<String, PathInfo> fetchHttpMethodInfo(HttpMetadata httpMetadata, Annotation methodAnnotation) {
        if (methodAnnotation instanceof GetMapping) {
            return httpMetadata.getPathInfo(HttpMethod.GET);
        }
        if (methodAnnotation instanceof PutMapping) {
            return httpMetadata.getPathInfo(HttpMethod.PUT);
        }
        if (methodAnnotation instanceof PostMapping) {
            return httpMetadata.getPathInfo(HttpMethod.POST);
        }
        if (methodAnnotation instanceof DeleteMapping) {
            return httpMetadata.getPathInfo(HttpMethod.DELETE);
        }
        if (methodAnnotation instanceof RequestMapping) {
            RequestMethod[] httpMethods = ((RequestMapping)methodAnnotation).method();
            if (null != httpMethods && 0 != httpMethods.length) {
                switch (httpMethods[0]) {
                    case GET: {
                        return httpMetadata.getPathInfo(HttpMethod.GET);
                    }
                    case PUT: {
                        return httpMetadata.getPathInfo(HttpMethod.PUT);
                    }
                    case POST: {
                        return httpMetadata.getPathInfo(HttpMethod.POST);
                    }
                    case DELETE: {
                        return httpMetadata.getPathInfo(HttpMethod.DELETE);
                    }
                }
            } else {
                return httpMetadata.getPathInfo(HttpMethod.ALL);
            }
        }
        return Collections.emptyMap();
    }

    @Override
    protected String[] getProduceTypes(Annotation methodAnnotation) {
        if (methodAnnotation instanceof RequestMapping) {
            String[] produces = ((RequestMapping)methodAnnotation).produces();
            return produces;
        }
        return null;
    }

    @Override
    protected String calculateMethodPath(Annotation methodAnnotation) {
        if (methodAnnotation instanceof GetMapping) {
            String[] paths = ((GetMapping)methodAnnotation).path();
            return null == paths || 0 == paths.length ? null : paths[0];
        }
        if (methodAnnotation instanceof PutMapping) {
            String[] paths = ((PutMapping)methodAnnotation).path();
            return null == paths || 0 == paths.length ? null : paths[0];
        }
        if (methodAnnotation instanceof PostMapping) {
            String[] paths = ((PostMapping)methodAnnotation).path();
            return null == paths || 0 == paths.length ? null : paths[0];
        }
        if (methodAnnotation instanceof DeleteMapping) {
            String[] paths = ((DeleteMapping)methodAnnotation).path();
            return null == paths || 0 == paths.length ? null : paths[0];
        }
        if (methodAnnotation instanceof RequestMapping) {
            String[] paths = ((RequestMapping)methodAnnotation).path();
            return null == paths || 0 == paths.length ? null : paths[0];
        }
        return null;
    }

    @Override
    protected String calculateClassPath(Class clazz) {
        RequestMapping requestMapping = clazz.getAnnotation(RequestMapping.class);
        if (null == requestMapping) {
            return null;
        }
        String[] paths = requestMapping.path();
        if (null == paths || 0 == paths.length) {
            return "";
        }
        return paths[0];
    }

    @Override
    protected void setParamInfo(ParamInfo paramInfo, Annotation annotation) {
        if (annotation.annotationType().equals(PathVariable.class)) {
            paramInfo.setName(((PathVariable)annotation).value());
            paramInfo.setType(ServiceParamType.Path);
        } else if (annotation.annotationType().equals(RequestParam.class)) {
            RequestParam requestParam = (RequestParam)annotation;
            paramInfo.setName(requestParam.value());
            paramInfo.setType(ServiceParamType.Query);
            if (!"\n\t\t\n\t\t\n\ue000\ue001\ue002\n\t\t\t\t\n".equals(requestParam.defaultValue())) {
                paramInfo.setDefaultValue(requestParam.defaultValue());
            }
        } else if (annotation.annotationType().equals(RequestBody.class)) {
            paramInfo.setType(ServiceParamType.Body);
        } else {
            throw new IllegalArgumentException("must at least one param type annotation ,paramInfo is " + paramInfo + " ,  annotation is " + annotation);
        }
    }
}

