/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.illidan.services.http.injector;

import com.taobao.illidan.common.utils.identify.Identifiable;
import com.taobao.illidan.services.http.annotation.javax.ws.rs.DELETE;
import com.taobao.illidan.services.http.annotation.javax.ws.rs.DefaultValue;
import com.taobao.illidan.services.http.annotation.javax.ws.rs.GET;
import com.taobao.illidan.services.http.annotation.javax.ws.rs.POST;
import com.taobao.illidan.services.http.annotation.javax.ws.rs.PUT;
import com.taobao.illidan.services.http.annotation.javax.ws.rs.Path;
import com.taobao.illidan.services.http.annotation.javax.ws.rs.PathParam;
import com.taobao.illidan.services.http.annotation.javax.ws.rs.Produces;
import com.taobao.illidan.services.http.annotation.javax.ws.rs.QueryParam;
import com.taobao.illidan.services.http.constants.HttpMethod;
import com.taobao.illidan.services.http.domain.HttpMetadata;
import com.taobao.illidan.services.http.domain.ParamInfo;
import com.taobao.illidan.services.http.domain.PathInfo;
import com.taobao.illidan.services.http.domain.ServiceParamType;
import com.taobao.illidan.services.http.injector.AbstractAnnotationHttpInfoInjector;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.Map;

@Identifiable(value="http:jaxrsAnnotation")
public class JAXRSHttpInfoInjector
extends AbstractAnnotationHttpInfoInjector {
    @Override
    protected Map<String, PathInfo> fetchHttpMethodInfo(HttpMetadata httpMetadata, Annotation methodAnnotation) {
        if (methodAnnotation instanceof GET) {
            return httpMetadata.getPathInfo(HttpMethod.GET);
        }
        if (methodAnnotation instanceof PUT) {
            return httpMetadata.getPathInfo(HttpMethod.PUT);
        }
        if (methodAnnotation instanceof POST) {
            return httpMetadata.getPathInfo(HttpMethod.POST);
        }
        if (methodAnnotation instanceof DELETE) {
            return httpMetadata.getPathInfo(HttpMethod.DELETE);
        }
        return Collections.emptyMap();
    }

    @Override
    protected String[] getProduceTypes(Annotation methodAnnotation) {
        String[] value = null;
        if (methodAnnotation instanceof Produces) {
            value = ((Produces)methodAnnotation).value();
        }
        return value;
    }

    @Override
    protected String calculateMethodPath(Annotation methodAnnotation) {
        if (methodAnnotation instanceof Path) {
            return ((Path)methodAnnotation).value();
        }
        return null;
    }

    @Override
    protected String calculateClassPath(Class clazz) {
        Path classPath = clazz.getAnnotation(Path.class);
        return null == classPath ? "" : classPath.value();
    }

    @Override
    protected void setParamInfo(ParamInfo paramInfo, Annotation annotation) {
        if (annotation instanceof PathParam) {
            paramInfo.setName(((PathParam)annotation).value());
            paramInfo.setType(ServiceParamType.Path);
        } else if (annotation instanceof QueryParam) {
            paramInfo.setName(((QueryParam)annotation).value());
            paramInfo.setType(ServiceParamType.Query);
        } else if (annotation instanceof DefaultValue) {
            paramInfo.setDefaultValue(((DefaultValue)annotation).value());
        }
    }
}

