/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.illidan.services.http.injector;

import com.taobao.illidan.common.utils.identify.Identifiable;
import com.taobao.illidan.services.core.Record;
import com.taobao.illidan.services.http.injector.AbstractHttpInfoInjector;
import com.taobao.illidan.services.http.injector.JAXRSHttpInfoInjector;
import com.taobao.illidan.services.http.injector.SpringHttpInfoInjector;
import com.taobao.illidan.services.http.jsonrpc.JsonRpcInfoInjector;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;

@Identifiable(value="http:combined")
public class CombinedHttpInfoInjector
extends AbstractHttpInfoInjector {
    private JsonRpcInfoInjector jsonRpcInfoInjector = new JsonRpcInfoInjector();
    private JAXRSHttpInfoInjector jaxrsAnnotationInjector = new JAXRSHttpInfoInjector();
    private SpringHttpInfoInjector springHttpInfoInjector = new SpringHttpInfoInjector();

    @Override
    public void injectServiceInfo(Record record, Class<?> service) {
        super.injectServiceInfo(record, service);
        InjectModel injectModel = this.getInjectModel(service.getAnnotations());
        if (injectModel.equals((Object)InjectModel.simple)) {
            this.jsonRpcInfoInjector.injectServiceInfo(record, service);
        }
    }

    public void injectLocationInfo(Record record, Collection locationObjects) {
        for (Object locationObject : locationObjects) {
            Method method = (Method)locationObject;
            InjectModel model = this.getInjectModel(method);
            switch (model) {
                case simple: {
                    this.jsonRpcInfoInjector.injectLocationInfo(record, Collections.singletonList(locationObject));
                    break;
                }
                case jaxr: {
                    this.jaxrsAnnotationInjector.injectLocationInfo(record, Collections.singletonList(locationObject));
                    break;
                }
                case spring: {
                    this.springHttpInfoInjector.injectLocationInfo(record, Collections.singletonList(locationObject));
                    break;
                }
            }
        }
    }

    private InjectModel getInjectModel(Method method) {
        Class<?> declaringClass = method.getDeclaringClass();
        Annotation[] annotaions = declaringClass.getAnnotations();
        InjectModel injectModel = this.getInjectModel(annotaions);
        if (!InjectModel.simple.equals((Object)injectModel)) {
            return injectModel;
        }
        Annotation[] methodAnnotaions = method.getAnnotations();
        injectModel = this.getInjectModel(methodAnnotaions);
        return injectModel;
    }

    private InjectModel getInjectModel(Annotation[] annotaions) {
        boolean containsJaxrs = false;
        boolean containsSpring = false;
        if (null != annotaions) {
            for (Annotation annotation : annotaions) {
                String annotationClassName = annotation.annotationType().getName();
                containsJaxrs |= annotationClassName.startsWith("com.taobao.illidan.services.http.annotation.javax.ws.rs");
                containsSpring |= annotationClassName.startsWith("com.taobao.illidan.services.http.annotation.spring");
            }
        }
        if (containsSpring) {
            return InjectModel.spring;
        }
        if (containsJaxrs) {
            return InjectModel.jaxr;
        }
        return InjectModel.simple;
    }

    private static enum InjectModel {
        simple,
        jaxr,
        spring;

    }
}

