/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.illidan.services.http.injector;

import com.taobao.illidan.common.utils.StringUtil;
import com.taobao.illidan.services.core.Record;
import com.taobao.illidan.services.http.domain.HttpMetadata;
import com.taobao.illidan.services.http.domain.ParamInfo;
import com.taobao.illidan.services.http.domain.PathInfo;
import com.taobao.illidan.services.http.domain.ServiceParamType;
import com.taobao.illidan.services.http.injector.AbstractHttpInfoInjector;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;

public abstract class AbstractAnnotationHttpInfoInjector
extends AbstractHttpInfoInjector {
    public void injectLocationInfo(Record record, Collection locationObjects) {
        for (Object locationObject : locationObjects) {
            Method method = (Method)locationObject;
            Annotation[] methodAnnotations = method.getDeclaredAnnotations();
            if (null == methodAnnotations || 0 == methodAnnotations.length) continue;
            HttpMetadata httpMetadata = (HttpMetadata)record.getMetadata(this.getAdditionalInfoType());
            Map<String, PathInfo> httpMethodInfos = this.findHttpMethodInfo(httpMetadata, method);
            PathInfo methodInfo = this.processPathInfo(method);
            String methodPath = this.calculateMethodPath(method);
            PathInfo original = httpMethodInfos.put(methodPath, methodInfo);
            if (null == original) continue;
            throw new IllegalArgumentException("Could not map path with different path info, path is " + methodPath + ", path info is " + methodInfo + ", original path info is " + original);
        }
    }

    String calculateMethodPath(Method method) {
        String methodPath = AbstractAnnotationHttpInfoInjector.ensureStartsWithSlash(this.calculateClassPath(method.getDeclaringClass()));
        for (Annotation methodAnnotation : method.getDeclaredAnnotations()) {
            String calculatedMethodPath = this.calculateMethodPath(methodAnnotation);
            if (null == calculatedMethodPath) continue;
            methodPath = methodPath + AbstractAnnotationHttpInfoInjector.ensureStartsWithSlash(calculatedMethodPath);
            break;
        }
        return methodPath;
    }

    Map<String, PathInfo> findHttpMethodInfo(HttpMetadata httpMetadata, Method method) {
        Map<String, PathInfo> pathInfos = null;
        for (Annotation methodAnnotation : method.getDeclaredAnnotations()) {
            pathInfos = this.fetchHttpMethodInfo(httpMetadata, methodAnnotation);
            if (null == pathInfos) continue;
            return pathInfos;
        }
        return Collections.emptyMap();
    }

    protected abstract Map<String, PathInfo> fetchHttpMethodInfo(HttpMetadata var1, Annotation var2);

    PathInfo processPathInfo(Method method) {
        PathInfo methodInfo = new PathInfo();
        methodInfo.setLocation(method.getName());
        for (Annotation methodAnnotation : method.getDeclaredAnnotations()) {
            String[] value = this.getProduceTypes(methodAnnotation);
            if (null == value || value.length <= 0) continue;
            methodInfo.setProduceType(value[0]);
        }
        Annotation[][] annotations = method.getParameterAnnotations();
        for (int i = 0; i < annotations.length; ++i) {
            ParamInfo paramInfo = new ParamInfo();
            methodInfo.addParamInfo(i, paramInfo);
            paramInfo.setName(i);
            paramInfo.setType(ServiceParamType.Body);
            for (Annotation annotation : annotations[i]) {
                this.setParamInfo(paramInfo, annotation);
            }
        }
        return methodInfo;
    }

    private static String ensureStartsWithSlash(String value) {
        if (StringUtil.isNullOrEmpty((String)value)) {
            return "";
        }
        return value.startsWith("/") ? value : "/" + value;
    }

    protected abstract String[] getProduceTypes(Annotation var1);

    protected abstract String calculateMethodPath(Annotation var1);

    protected abstract String calculateClassPath(Class var1);

    protected abstract void setParamInfo(ParamInfo var1, Annotation var2);
}

