/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.illidan.services.http;

import com.taobao.illidan.common.utils.StringUtil;
import com.taobao.illidan.common.utils.logging.InternalLogger;
import com.taobao.illidan.common.utils.logging.InternalLoggerFactory;
import com.taobao.illidan.services.core.ServiceDiscovery;
import com.taobao.illidan.services.http.UndertowHandler;
import io.undertow.Handlers;
import io.undertow.Undertow;
import io.undertow.UndertowOptions;
import io.undertow.server.HttpHandler;
import org.xnio.Options;

public class UndertowHttpServer {
    private static final InternalLogger LOGGER = InternalLoggerFactory.getInstance(UndertowHttpServer.class);
    private Undertow server;
    private UndertowHandler handler;

    public UndertowHttpServer(ServiceDiscovery discovery) {
        this.handler = new UndertowHandler(discovery);
    }

    public void start(String host, int port) {
        if (StringUtil.isNullOrEmpty((String)host)) {
            host = "0.0.0.0";
        }
        this.server = Undertow.builder().addHttpListener(port, host).setBufferSize(16384).setIoThreads(Runtime.getRuntime().availableProcessors() * 2).setSocketOption(Options.BACKLOG, (Object)10000).setServerOption(UndertowOptions.ALWAYS_SET_KEEP_ALIVE, (Object)false).setServerOption(UndertowOptions.ALWAYS_SET_DATE, (Object)true).setServerOption(UndertowOptions.RECORD_REQUEST_START_TIME, (Object)false).setHandler((HttpHandler)Handlers.header((HttpHandler)this.handler.routingHandler(), (String)"Server", (String)"Illidan")).setWorkerThreads(Math.max(256, Runtime.getRuntime().availableProcessors() * 32)).build();
        try {
            this.server.start();
        }
        catch (Exception e) {
            LOGGER.error("start http server failed, host is {}, port is {}.", (Object)host, (Object)port);
            throw e;
        }
        LOGGER.info("start http server, host is {}, port is {}.", (Object)host, (Object)port);
    }

    public void stop() {
        if (null != this.server) {
            this.server.stop();
            LOGGER.info("stop http server");
        }
    }

    public UndertowHandler getHandler() {
        return this.handler;
    }
}

